<?php 

	header("Content-Type: text/css; charset=utf-8");
	
	$absolute_path = __FILE__;
	$path_to_file = explode( 'wp-content', $absolute_path );
	$path_to_wp = $path_to_file[0];
	require_once( $path_to_wp.'/wp-load.php' );
	require_once( $path_to_wp.'/wp-includes/functions.php');
	
	$template_uri = get_template_directory_uri();

	

	if ( function_exists( 'get_option_tree') ) {
		$alterego_font_family = get_option_tree("alterego_main_google_font_family");
		$alterego_main_color = array("",get_option_tree( 'alterego_main_color_1' ),get_option_tree( 'alterego_main_color_2' ),get_option_tree( 'alterego_main_color_3' ),get_option_tree( 'alterego_main_color_4' ),get_option_tree( 'alterego_main_color_5' ),get_option_tree( 'alterego_main_color_6' ),get_option_tree( 'alterego_main_color_7' ));
		if(isset($_GET["maincolor"])) $alterego_main_color[1] = "#".$_GET["maincolor"];
		$alterego_font_size = get_option_tree( 'alterego_main_font_size', '', false, true, 0 ).get_option_tree( 'alterego_main_font_size', '', false, true, 1 );
	}
?>
/*----------------------------------------------------------------------------- 

STYLE CONFIGURATION FROM alterego THEME

Screen Stylesheet 

version:   	1.0 
date:      	20.04.2012 
author:		freshline
email:     	support@version-four.com 
website:   	http://www.version-four.com
-----------------------------------------------------------------------------*/



/*********************************************
			TABLE OF CONTENT
			
			BASICS
			cONTENTS
			MENU/HEAD
			NAVIGATION
			SOCIALS
			SHORTCODES
			QUOTES
			DIVIDER
			PAGINATION
			PORTFOLIO
			COMMENTLIST
			WP CORE
			BUTTONS
			PARTNERS
			INPUTBOX
			VIDEO CONTAINER
			TEASER
			FOOTER
			WIDGET
				SITEMAP
				SKILLS
			TWITTER
			PRE			
			BANNER
			SHORTCODES
			PRICETABLES
			ACCORDION
			TABS
			LISTS
			BLOCKQUOTES
			BLOG
			
			
		
*********************************************/
							
							

/***********************
	-	BASICS 	-
***********************/
html 		{	width: 100%;	 margin: 0px;		overflow-x:hidden; 	padding: 0;}

body		{	margin:0px; background-color:<?php echo get_option_tree("alterego_body_background_color");?>; font-family: arial,verdana; font-size:14px; color:<?php echo get_option_tree("alterego_text_color_1");?>; font-weight:500;}

.container	{ 	z-index:10;}

ol, ul 		{   list-style: none; }

a			{ text-decoration:none; 
				/*-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;*/
			}

a:hover 	{	text-decoration: none;	cursor: pointer;	 }
a:focus 	{   outline: none; }

p a, p a:visited {color:<?php echo $alterego_main_color[1];?>;}

a.highlight,
a.highlight:visited	{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}

a.highlight:hover	{	color:<?php echo $alterego_main_color[1];?> !important }

.sidebar a,
.sidebar a:visited						{	color:<?php echo $alterego_main_color[3];?> }
.sidebar a:hover						{	color:<?php echo get_option_tree("alterego_text_color_1");?>; }

.fh-pen a,
.fh-pen a:visited {color:<?php echo $alterego_main_color[1];?>;}

.clear		{	clear:both;}


			h1.purple,h2.purple,h3.purple,h4.purple,h5.purple,h6.purple,p.purple	{	color:#c93157;}
			h1.red,h2.red,h3.red,h4.red,h5.red,h6.red,p.red	{	color:#ff0000;}
			h1.darkgrey,h2.darkgrey,h3.darkgrey,h4.darkgrey,h5.darkgrey,h6.darkgrey,p.darkgrey	{	color:<?php echo get_option_tree("alterego_text_color_2");?>;}
			h1.orange,h2.orange,h3.orange,h4.orange,h5.orange,h6.orange,p.orange	{	color:#e43300;}
			h1.yellow,h2.yellow,h3.yellow,h4.yellow,h5.yellow,h6.yellow,p.yellow	{	color:#f4a600;}
			h1.green,h2.green,h3.green,h4.green,h5.green,h6.green,p.green	{	color:#569025;}
			h1.apple,h2.apple,h3.apple,h4.apple,h5.apple,h6.apple,p.apple	{	color:#91ba1e;}
			h1.blue,h2.blue,h3.blue,h4.blue,h5.blue,h6.blue,p.blue	{	color:#007fb0;}
			h1.ocean,h2.ocean,h3.ocean,h4.ocean,h5.ocean,h6.ocean,p.ocean	{	color:<?php echo $alterego_main_color[1];?> !important;}

			h1, h2, h3, h4, h5, h6 {
				color: <?php echo get_option_tree("alterego_text_color_2");?>;
				font-family:"PT Sans Narrow",Arial;
				font-weight: 400;		
			}
			
			h1 a, h2 a, h3 a, h4 a, h5 a, h6 a { font-weight: inherit; }
			h1 { font-size: <?php echo get_option_tree( 'alterego_h1_font_size', '', false, true, 0 ).get_option_tree( 'alterego_h1_font_size', '', false, true, 1 );?>; line-height: <?php echo (get_option_tree( 'alterego_h1_font_size', '', false, true, 0 )+10).get_option_tree( 'alterego_h1_font_size', '', false, true, 1 );?>; margin-bottom: 15px !important;}
			h2 { font-size: <?php echo get_option_tree( 'alterego_h2_font_size', '', false, true, 0 ).get_option_tree( 'alterego_h2_font_size', '', false, true, 1 );?>; line-height: <?php echo (get_option_tree( 'alterego_h2_font_size', '', false, true, 0 )+8).get_option_tree( 'alterego_h2_font_size', '', false, true, 1 );?>; margin-bottom: 15px !important; }
			h3 { font-size: <?php echo get_option_tree( 'alterego_h3_font_size', '', false, true, 0 ).get_option_tree( 'alterego_h3_font_size', '', false, true, 1 );?>; line-height: <?php echo (get_option_tree( 'alterego_h3_font_size', '', false, true, 0 )+8).get_option_tree( 'alterego_h3_font_size', '', false, true, 1 );?>;  margin-bottom: 15px !important;  }
			h4 { font-size: <?php echo get_option_tree( 'alterego_h4_font_size', '', false, true, 0 ).get_option_tree( 'alterego_h4_font_size', '', false, true, 1 );?>; line-height: <?php echo (get_option_tree( 'alterego_h4_font_size', '', false, true, 0 )+7).get_option_tree( 'alterego_h4_font_size', '', false, true, 1 );?>; margin-bottom: 15px !important;  }
			h5 { font-size: <?php echo get_option_tree( 'alterego_h5_font_size', '', false, true, 0 ).get_option_tree( 'alterego_h5_font_size', '', false, true, 1 );?>; line-height: <?php echo (get_option_tree( 'alterego_h5_font_size', '', false, true, 0 )+5).get_option_tree( 'alterego_h5_font_size', '', false, true, 1 );?>; margin-bottom: 15px !important;   }
			h6 { font-size: <?php echo get_option_tree( 'alterego_h6_font_size', '', false, true, 0 ).get_option_tree( 'alterego_h6_font_size', '', false, true, 1 );?>; line-height: <?php echo (get_option_tree( 'alterego_h6_font_size', '', false, true, 0 )+5).get_option_tree( 'alterego_h6_font_size', '', false, true, 1 );?>; margin-bottom: 15px !important;  }

			.star	{	color:#e43300;}
	
.centerme	{	margin-left:auto;margin-right:auto;	}
.content { padding-top: 20px; }


/***********************************
	-	SIDEBAR HACKS	-
************************************/




.leftfloat {float:left;}
.rightfloat { float: right;}
.rightfloat_leftfloat { float: right;}
.maincolor	{	color:#1D78CB}


.main_bg_color_1,span.color_1,.dropcap.color_1:first-letter { background-color: <?php echo $alterego_main_color[1];?> !important }
.main_bg_color_2,span.color_2,.dropcap.color_2:first-letter { background-color:<?php echo $alterego_main_color[2];?> !important; }
.main_bg_color_3,span.color_3,.dropcap.color_3:first-letter { background-color:<?php echo $alterego_main_color[3];?> !important; }
.main_bg_color_4,span.color_4,.dropcap.color_4:first-letter { background-color:<?php echo $alterego_main_color[4];?> !important; }
.main_bg_color_5,span.color_5,.dropcap.color_5:first-letter { background-color:<?php echo $alterego_main_color[5];?> !important; }


.main_bg_color_white ,span.color_white,.dropcap.color_white:first-letter { background-color: <?php echo $alterego_main_color[5];?> !important;}
a.main_bg_color_white {color:<?php echo get_option_tree("alterego_text_color_2");?> !important; text-shadow: 1px 0 1px #CCC !important;background-color: <?php echo $alterego_main_color[5];?> !important;}



.main_bg_color_5 h5	{	color:<?php echo $alterego_main_color[3];?> !important; text-shadow:none;}

.main_bg_color_lightgrey,span.color_lightgrey,.dropcap.color_lightgrey:first-letter { background-color: <?php echo get_option_tree("alterego_text_color_1");?> !important}
.main_bg_color_black,span.color_black,.dropcap.color_black:first-letter { background-color: #000 !important}
.main_bg_color_darkgrey,span.color_darkgrey,.dropcap.color_darkgrey:first-letter { background-color: <?php echo get_option_tree("alterego_text_color_2");?> !important}

.main_text_color_1,h5.color_1,.pricecol .main_text_color_1 h2 { color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_2,h5.color_2,.pricecol .main_text_color_2 h2 { color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_3,h5.color_3,.pricecol .main_text_color_3 h2 { color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_4,h5.color_4,.pricecol .main_text_color_4 h2 { color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_5,h5.color_5,.pricecol .main_text_color_5 h2 { color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_6,h5.color_6,.pricecol .main_text_color_6 h2 { color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_7,h5.color_7,.pricecol .main_text_color_7 h2{ color: <?php echo $alterego_main_color[1];?> !important}
.main_text_color_white,h5.color_white,.pricecol .main_text_color_white h2 { color: <?php echo $alterego_main_color[5];?> !important}
.main_text_color_lightgrey,h5.color_lightgrey,.pricecol .main_text_color_lightgrey h2 { color: <?php echo get_option_tree("alterego_text_color_1");?> !important}

/***************************
	-	CONTENTS	-
***************************/

#content_container		{	 width:960px;margin:auto; background-color:<?php echo $alterego_main_color[5];?>; padding:0px 30px; z-index:3; position:relative;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  
						}			

.footerholder			{	 width:960px;margin:auto;   background-color:<?php echo get_option_tree('alterego_footer_color');?>; z-index:3; position:relative;padding:0px 30px 0px;
							/*-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  */
						}			
.footer_container		{	 background-color:<?php echo get_option_tree('alterego_footer_color');?>;  min-height:5px;  z-index:3; position:relative; border-top:5px solid <?php echo $alterego_main_color[1];?>;padding-top:50px;}

.subfooterholder		{	  width:960px;margin:auto;  background-color:<?php echo get_option_tree('alterego_subfooter_color');?>; z-index:3; position:relative;padding:10px 30px;
							/*-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  */
						}			
.subfooter_container	{	padding:0px 0px;z-index:3; position:relative; }
.subfooter_logo			{	max-height:41px; float:right;}

#content			{	  width:100%; }
	

.container_20p		{	padding:20px;}
	
	
.fullbgcover			{ width:100%;height:100%;background:url(../images/background/blur_pattern.png) repeat;}



/*******************************
	-	MENU / HEAD 	-	
********************************/
#header 						{  width:960px; height:5px; border-top:5px solid <?php echo $alterego_main_color[1];?>; padding-top:20px;}

.entering_holder				{	background-color:#363d43; width:920px; padding:60px 20px 10px 20px;position:relative; margin-bottom:0px !important;}
.entering_holder h3 			{ 	color:<?php echo $alterego_main_color[5];?>; text-shadow:1px 1px 0px #000;}
.entering_holder p 				{ 	color:<?php echo get_option_tree("alterego_text_color_1");?>; margin-bottom:0px !important; text-shadow:1px 1px 0px #000;}

.entering_holder .hordiv h4 	{ 	background:url(../images/other/separator_banner_bottom.png) repeat-y; min-width:14px; padding:20px 20px; height:100%; color:<?php echo get_option_tree("alterego_text_color_1");?>; text-shadow:1px 1px 0px #000;}
.entering_holder .purchase		{	margin-top:14px;margin-right:20px;}



.pagetitle			{	float:left;	}
.pagetitle h3		{	margin-bottom:0px !important; line-height:1; font-size:23px;}


.sitelogo			{	float:left;position:relative;  margin-top:20px;overflow:hidden;width:<?php echo get_option_tree('alterego_logo_width');?>px; height:<?php echo get_option_tree('alterego_logo_height');?>px; background:url(<?php echo get_option_tree('alterego_logo_src');?>) no-repeat;}



.headright_holder	{	float:right;}
.headerinfo			{	float:left;font-size:14px; color:<?php echo $alterego_main_color[3];?>; margin-right:20px; margin-top:44px;}
.headerinfo span	{	font-size:14px;}

.menuright_holder 		{	float:right;}
.menuright_holder span	{	float:left; position:relative; margin-top:7px; margin-right:20px; color:#e3e3e3; font-size:14px;  font-style:italic; font-weight:200; <?php echo $alterego_font_family;?>  line-height:1; text-shadow:1px 1px 0px #000; }

 

 /*********************************
	-	NAVIGATION - MENU	-
	
	border-top:2px solid <?php echo $alterego_main_color[2];?>; border-bottom:2px solid <?php echo $alterego_main_color[2];?>;
***********************************/	


#navholder				{   margin-left:-30px; width:990px; background:url(../images/other/decor_inside.png) repeat; background-color:<?php echo $alterego_main_color[2];?>; position:relative;z-index:999;   height:70px; padding-top:12px; padding-left:30px;}
#nav					{	position:relative;	z-index:1000;	height:auto;	font-size:24px;	font-family:"PT Sans Narrow";	font-weight:500;color:<?php echo $alterego_main_color[3];?>; }

.nav_shadow				{	background:url(../images/other/shadow_slider_bottom.png); width:960px; height:40px; margin-bottom:-40px;}

#nav a					{	color:<?php echo $alterego_main_color[3];?>; -webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;}
						

#nav .arrow_menu		{	background:url(../images/other/arrow_menu_sub.png) no-repeat right bottom; float:right; width:9px; height:9px; margin-left:5px;padding-top:12px;}

#nav ul					{	list-style:none;	 position:relative;}
#nav ul>li				{	padding:10px 10px; float:left;	 position:relative;	z-index:10; cursor:pointer; margin-right:25px;
						-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;}

#nav >ul>li:hover,
#nav >ul>li.current-menu-item,
#nav >ul>li.current_page_ancestor		{	background-color:<?php echo $alterego_main_color[5];?>; 
											border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;  	
											-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.2);        -moz-box-shadow:    0px 0px 4px 0px rgba(0, 0, 0, 0.2);      box-shadow:   0px 0px 4px 0px rgba(0, 0, 0, 0.2);										
										}
										
#nav >ul>li.withchilds:hover		{	border-radius: 5px 5px 0px 0px; -moz-border-radius: 5px 5px 0px 0px; -webkit-border-radius: 5px 5px 0px 0px; }
									
						
#nav >ul>li:hover:after, #nav >ul>li.current-menu-item:after ,
#nav >ul>li.current_page_ancestor:after	
									{		content: '';	position: absolute;	top: -13px;	left: 50%;	margin-left: -6px;	width: 0;	height: 0;	border-left: 6px solid transparent;	border-right: 6px solid transparent;	border-top: 6px solid <?php echo $alterego_main_color[1];?>;	}

#nav >ul>li .menu_subtitle			{ font-size:14px; font-family:"PT Sans Narrow"; color:<?php echo $alterego_main_color[3];?>; margin-top:10px;line-height:7px; visibility:hidden; }					

#nav >ul>li:hover .menu_subtitle,
#nav >ul>li.current-menu-item .menu_subtitle,
#nav >ul>li.current_page_ancestor .menu_subtitle	{	 visibility:visible; }

#nav >ul>li .menudivider			{    /*margin-top:8px; height:1px; width:100%; background:#c4c4c4; visibility:hidden; margin-bottom:-7px;*/}					
#nav >ul>li:hover .menudivider		{	 visibility:visible; }

#nav >ul>li:hover >a,
#nav >ul>li.current-menu-item >a,
#nav >ul>li.current_page_ancestor >a {	color:<?php echo $alterego_main_color[1];?>; }


#nav ul li ul a				{ 	width:200px;}



#nav ul li>ul			{	display:none;    left: 0px; position:absolute;top:100%; margin-top:2px;  
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.2);        -moz-box-shadow:    0px 0px 4px 0px rgba(0, 0, 0, 0.2);      box-shadow:   0px 0px 4px 0px rgba(0, 0, 0, 0.2);									
						}


#nav  ul li ul li		{	color:<?php echo $alterego_main_color[5];?> !important; font-size:16px;font-weight:500; 
							font-family:"PT Sans Narrow";
							padding-bottom:2px; font-weight:200;  background:<?php echo $alterego_main_color[5];?>; 							
							margin-left:0px !important; margin-right:0px !important;clear:both; 
							padding-left:10px;width:160px; margin-top:0px;margin-bottom:0px;							
						}

#nav ul li ul li:first-child	{ padding-top:12px; border-radius: 0px 0px 0px 0px; -moz-border-radius: 0px 0px 0px 0px; -webkit-border-radius: 0px 0px 0px 0px;   }							
#nav ul li ul li:last-child		{ padding-bottom:12px; border-radius: 0px 0px 5px 5px; -moz-border-radius: 0px 0px 5px 5px; -webkit-border-radius: 0px 0px 5px 5px;   }							



#nav ul li ul li:hover a			{	color:#555;}
#nav ul li ul li.current-menu-item a{	color:<?php echo $alterego_main_color[1];?>}

   
   
/*************************
	-	SOCIALS	-
*************************/

.socials			{	position:relative; height:16px;}	

.tp_teaser_rotator .socials	{	margin-top:2px;}

.socials li				{	position:relative; float:left;  margin-right:13px; z-index:100;}
.subfooter_container .socials li	{	margin-right:15px;}
.footer_holder .socials li	{ margin-right:15px;}

.socials li:last-child	{	margin-right:0px; }

.socials .soc .bg 	{	 background-position:top; 	-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;
					}

.socials li:last-child .soc	{	margin-right:0px; }			 

.socials .soc .tooltip	{	
							white-space:nowrap;
							position:absolute;  top:11px;  margin-top:-20px;  margin-left:50%;  font-weight:500;
							padding:0px 7px 0px 7px; background:<?php echo $alterego_main_color[1];?>; color:<?php echo $alterego_main_color[5];?>; <?php echo $alterego_font_family;?> font-size:12px; 
							border-radius: 2px;   -moz-border-radius: 2px;   -webkit-border-radius: 2px;
							visibility:hidden; -moz-opacity:0; filter:alpha(opacity=0); opacity:0;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  
							-webkit-transition: opacity 0.3s,margin 0.3s ease-out; -moz-transition: opacity 0.3s,margin 0.3s ease-out; -o-transition: opacity 0.3s,margin 0.3s ease-out; -ms-transition: opacity 0.3s,margin 0.3s ease-in-out;
						}

.socials .soc .tooltip:after{
	content: '';
	position: absolute;
	bottom: -6px;
	left: 50%;
	margin-left: -6px;
	width: 0;
	height: 0;
	border-left: 6px solid transparent;
	border-right: 6px solid transparent;
	border-top: 6px solid <?php echo $alterego_main_color[1];?>;
}						
						
						
.socials .soc:hover .tooltip { visibility:visible; -moz-opacity:1; filter:alpha(opacity=100); opacity:1;margin-top:-47px;}						
.socials .soc:hover	.bg {	background-position:bottom;	}		  

.socials .rss .bg			{	width:16px; height:16px; background:url(../images/footer/s_1.png) no-repeat;}
.socials .twitter .bg		{	width:24px; height:16px; background:url(../images/footer/s_2.png) no-repeat;}
.socials .linked .bg		{	width:17px; height:16px; background:url(../images/footer/s_3.png) no-repeat;}
.socials .facebook .bg		{	width:8px; height:16px; background:url(../images/footer/s_4.png) no-repeat;}
.socials .pinteres .bg		{	width:13px; height:16px; background:url(../images/footer/s_5.png) no-repeat;}
.socials .youtube .bg		{	width:18px; height:16px; background:url(../images/footer/s_6.png) no-repeat;}
.socials .vimeo .bg			{	width:18px; height:16px; background:url(../images/footer/s_7.png) no-repeat;}
.socials .flickr .bg		{	width:18px; height:16px; background:url(../images/footer/s_8.png) no-repeat;}
.socials .skype .bg			{	width:17px; height:16px; background:url(../images/other/s_4.png) no-repeat;}
.socials .email .bg			{	width:21px; height:16px; background:url(../images/other/s_5.png) no-repeat;}

ul.socials li p {display:none;}

.sharings { margin-top: 3px;}

.portfolio_full_holder .sharings {float:left;}
.portfolio_full_holder .shpinterest {width:75px}

 
   
   
   
 /******************************
	-	SHORTCODES	-
********************************/



	.fh-pin					{  min-width:10px; min-height:18px;  padding-left:15px; padding-top:0px;  background:url(../images/footer/i_pin.png) no-repeat 0px 2px;}		
	.fh-phone				{  min-width:10px; min-height:19px;  padding-left:15px; padding-top:0px; background:url(../images/footer/i_phone.png) no-repeat 0px 2px;}		
	.fh-pen					{  min-width:6px; min-height:18px;  padding-left:15px; padding-top:0px; background:url(../images/footer/i_pen.png) no-repeat 0px 2px;}		
	
	.fh-category			{  min-width:10px; height:10px;  padding-left:15px; padding-top:0px; background:url(../images/other/i_category.png) no-repeat 0px 0px;}	
	.fh-category.darkfh		{  min-width:10px; height:10px;  padding-left:15px; padding-top:0px; background:url(../images/other/i_category_filter.png) no-repeat 0px 0px;}	
	.fh-share				{  min-width:10px; height:10px;  padding-left:15px; padding-top:0px; background:url(../images/other/i_share.png) no-repeat 0px 0px;}	
	
	 .fh-comment			{  width:50px; height:40px;  position:relative;  background:url(../images/other/ic_1.png) no-repeat 0px 0px;}	
	 .fh-note				{  width:40px; height:40px;  position:relative;  background:url(../images/other/ic_2.png) no-repeat 0px 0px;}	
	 .fh-video				{  width:34px; height:40px;  position:relative;  background:url(../images/other/ic_3.png) no-repeat 0px 0px;}	
	 .fh-audio				{  width:25px; height:40px;  position:relative;  background:url(../images/other/ic_4.png) no-repeat 0px 0px;}	
	 .fh-download			{  width:45px; height:40px;  position:relative;  background:url(../images/other/ic_5.png) no-repeat 0px 0px;}	
	 .fh-link				{  width:32px; height:40px;  position:relative;  background:url(../images/other/ic_6.png) no-repeat 0px 0px;}	
	 .fh-mouth				{  width:44px; height:40px;  position:relative;  background:url(../images/other/ic_7.png) no-repeat 0px 0px;}	
	 .fh-photo				{  width:36px; height:40px;  position:relative;  background:url(../images/other/ic_8.png) no-repeat 0px 0px;}	
	 
	 .fh-think				{  width:50px; height:50px;  position:relative;  background:url(../images/other/is_1.png) no-repeat 0px 0px;}	
	 .fh-lock				{  width:50px; height:50px;  position:relative;  background:url(../images/other/is_2.png) no-repeat 0px 0px;}	
	 .fh-book				{  width:50px; height:50px;  position:relative;  background:url(../images/other/is_3.png) no-repeat 0px 0px;}	
	 .fh-micro				{  width:50px; height:50px;  position:relative;  background:url(../images/other/is_4.png) no-repeat 0px 0px;}	
	 .fh-ipad				{  width:50px; height:50px;  position:relative;  background:url(../images/other/is_5.png) no-repeat 0px 0px;}	
	 .fh-check				{  width:50px; height:50px;  position:relative;  background:url(../images/other/is_6.png) no-repeat 0px 0px;}	
	 
	 
	 

	
	.tag_holder				{ 	}
	.tag_holder li			{	float:left;}
	.tag					{	cursor:pointer; min-width:19px; height:17px; padding:2px 10px 4px 19px; background:url(../images/tiles/tagarrow.png) no-repeat;color:<?php echo $alterego_main_color[5];?>; font-size:11px; font-weight:bold; margin-right:10px;}
	.tag.last			{	margin-right:0px;}
	.tag a					{	color:<?php echo $alterego_main_color[5];?>; }	
	
	.service		{	width:50px; height:50px; -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
						border-radius: 50px; -moz-border-radius: 50px; -webkit-border-radius: 50px; float:left; margin-right:20px;
					}
	
	
	
	
/********************************
	-	QUOTES	- SHORTCODES
********************************/


.quote-left						{	text-align:left; background:url(../images/other/quote_decor_line.png) repeat-y; padding:10px 0px 10px 16px;}
.pagetitleholder				{   width:960px; margin-left:-30px; background:#777;  padding:30px 30px; border-top:1px solid #ddd; border-bottom:1px solid #ddd; background:#eee;}


 
 /**************************************************
	-	QUOTES	-		ROTATOR
*****************************************************/
#quotes_carousel		{	height: 95px;	 overflow: hidden;   position: relative;	width:960px;	margin-left:auto;margin-right:auto; z-index:50;	margin-bottom:0px;}
#quotes_carousel li		{	display:none; position:absolute; width:100%;}
.quote, .quote h3		{	color:<?php echo $alterego_main_color[3];?> !important; position:relative;	text-align:center;	width:100%; margin-bottom:0px; line-height:28px;}

	
#quotes_carousel.customerquotes			{	height:190px;  width:760px; }

#quotes_carousel .quoteimg				{	margin-top:10px;}
 
	



/*******************************
	-	DIVIDER -	
********************************/

	.bigdivider p		{ color:#777;}
	.pagedivider, .linedivider		{ border-bottom:2px solid #cecece;}
	.smallsizedivider	{			}
	.killerclear		{	clear:both;	height:20px;}
	.colordivider		{ background:<?php echo $alterego_main_color[1];?>; width:960px; height:5px; }
	
	
/********************************
	-	PAGINATION	-
*********************************/


.page				{	padding:5px 11px 5px; margin-right:5px; border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; height:30px;						
						-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
						cursor:pointer;
						color:<?php echo $alterego_main_color[5];?> !important; text-shadow:1px 0px 1px #606060; font-weight:500; font-size:14px; line-height:1;
					}


.page.grey		{						
						/* IE9 SVG, needs conditional override of 'filter' to 'none' */
						background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodDodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzM2M2Q0MyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMxYzIwMjMiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
						background: -moz-linear-gradient(top, #9D9EA3 0%, #848889 100%); /* FF3.6+ */
						background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#9D9EA3), color-stop(100%,#848889)); /* Chrome,Safari4+ */
						background: -webkit-linear-gradient(top, #9D9EA3 0%,#848889 100%); /* Chrome10+,Safari5.1+ */
						background: -o-linear-gradient(top, #9D9EA3 0%,#848889 100%); /* Opera 11.10+ */
						background: -ms-linear-gradient(top, #9D9EA3 0%,#848889 100%); /* IE10+ */
						background:  linear-gradient(top, #9D9EA3 0%,#848889 100%); /* W3C */						
						filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#9D9EA3', endColorstr='#848889',GradientType=0 ); /* IE6-8 */					
					}
					
.page.grey:hover,
.page.grey.marked		{	
						background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzM2M2Q0MyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMxYzIwMjMiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
						background: -moz-linear-gradient(top, #2E353B 0%, #2E353B 100%); /* FF3.6+ */
						background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#2E353B), color-stop(100%,#2E353B)); /* Chrome,Safari4+ */
						background: -webkit-linear-gradient(top, #2E353B 0%,#2E353B 100%); /* Chrome10+,Safari5.1+ */
						background: -o-linear-gradient(top, #2E353B 0%,#2E353B 100%); /* Opera 11.10+ */
						background: -ms-linear-gradient(top, #2E353B 0%,#2E353B 100%); /* IE10+ */
						background:  linear-gradient(top, #2E353B 0%,#2E353B 100%); /* W3C */						
						filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#2E353B', endColorstr='#2E353B',GradientType=0 ); /* IE6-8 */					
						}						
										



/*******************************
	-	PORTFOLIO / BLOG	-
********************************/

/*	FULL PAGE PORTFOLIO	 && BLOG*/
.portfolio_full_holder,.blog			{	width:100%;  /*overflow:hidden;  */
											-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
											background:<?php echo $alterego_main_color[5];?>; 
										}
.blog									{	overflow:visible;}									
.blog .detailholder						{	padding:20px 0px 15px 20px;}
.blog .smalldetailholder				{	padding:20px 0px 20px 0px; }

.blog .detailholder p strong, p strong 			{	color:<?php echo get_option_tree("alterego_text_color_2");?>; font-weight: normal;	}
										
.portfolio_full_holder .portfolio_mediaholder,
.blog .mediaholder,
.sidebar .mediaholder										{	position:relative; width:100%; overflow:hidden;}					   

.sidebar .one_third .mediaholder	{	width:66px !important; -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);}



.portfolio_full_holder .portfolio_mediaholder img,
.blog .mediaholder img,
.sidebar .mediaholder img							 		{	position:relative; left:0px; top:0px;  width:100%; margin-bottom:-6px;}

.portfolio_full_holder .portfolio_leftside		{	float:right; width:470px; }
.portfolio_full_holder .portfolio_rightside		{	float:left; width:470px; }

.portfolio_full_holder .portfolio_rightside		{	padding:0px;  width:490px;}

.withsidebar .portfolio_full_holder .portfolio_leftside		{	width:715px;}
.withsidebar .portfolio_full_holder .portfolio_rightside 	{	width:715px;}


.portfolio_full_holder  h4.smallmargin,
.blog h4.smallmargin, .blog h5.smallmargin				{	margin-bottom:0px !important;}


/*  BLOG TYPE	*/
.typeholder										{	margin:15px 20px; float:left;}
												
.blog .blog_date								{	float:right; margin-right:50px;margin-top:5px;}			
.blog .blog_date .day							{	color:<?php echo $alterego_main_color[5];?>; font-size:38px;  font-family:"PT Sans Narrow",Arial; padding-right:10px; margin-right:10px; border-right:1px solid <?php echo $alterego_main_color[2];?>; line-height:38px; color:<?php echo $alterego_main_color[2];?>;}									
.blog .blog_date .month_year					{	font-size:16px; font-family:"PT Sans Narrow"; line-height:16px;padding-top:4px; color:<?php echo $alterego_main_color[2];?>;}									
.blog .blog_date .month_year_year				{	font-size:14px; font-family:"PT Sans Narrow"; color:<?php echo $alterego_main_color[2];?>;}	

.blog .topline h5 a								{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}								

.post_text_readmore { background-color: <?php echo $alterego_main_color[1]; ?> !important}
.post_image_readmore { background-color: <?php echo $alterego_main_color[1];?> !important}
.post_audio_readmore { background-color: <?php echo $alterego_main_color[1];?> !important}
.post_video_readmore { background-color: <?php echo $alterego_main_color[1];?> !important}
.post_slider_readmore { background-color: <?php echo $alterego_main_color[1];?> !important}
.post_download_readmore { background-color: <?php echo $alterego_main_color[1];?> !important}
.post_link_readmore { background-color: <?php echo $alterego_main_color[1];?> !important}

.post_download_downloadbutton { background-color: <?php echo $alterego_main_color[1];?> !important}
.post_link_linkbutton { background-color: <?php echo $alterego_main_color[1];?> !important}


.portfolio_full_holder .portfolio_mediaholder .fullcover,
.blog .fullcover,
.sidebar .fullcover											{	position:absolute;top:0px; left:0px; width:100%; height:100%; background-color:<?php echo $alterego_main_color[5];?> !important ;
																-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;	
																z-index:5;
																-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; 
																
															}
				
.portfolio_full_holder  .viewproject,
.blog .viewproject										{   z-index:8;text-align:center; position:absolute;   top:50%; margin-top:20px; width:100%;										 
																-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;	
																-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; 
															}
															
.portfolio_full_holder  .viewproject a,
.blog  .viewproject a									{ 		font-family:"PT Sans Narrow",Arial; text-align:center; padding:5px 10px; background-color:#343434; color:<?php echo $alterego_main_color[5];?>; font-size:15px; 
																-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
															}								
									
.portfolio_full_holder .portfolio_mediaholder:hover .viewproject,
.blog .mediaholder:hover .viewproject					{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=1)";	filter: alpha(opacity=1);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1; 
																		margin-top:-10px;}

.portfolio_full_holder .portfolio_mediaholder:hover .fullcover,
.blog .mediaholder:hover .fullcover,
.sidebar .mediaholder:hover .fullcover					{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=80)";	filter: alpha(opacity=80);	-moz-opacity: 0.8;	-khtml-opacity: 0.8;	opacity: 0.8; }
																
.sidebar .viewproject .plusicon								{	width:38px; height:38px;  margin-top:20px; background:url(../images/other/plus_hover.png) no-repeat top left; z-index:8; position:absolute;   top:50%; left:50%; margin-left:-19px; 										 
																-webkit-transition: filter,margin 0.3s ease-out; -moz-transition: filter,margin 0.3s ease-out; -o-transition: filter,margin 0.3s ease-out; -ms-transition: filter,margin 0.3s ease-in-out;	
																-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0;}

.sidebar .mediaholder:hover .viewproject .plusicon			{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=1)";	filter: alpha(opacity=1);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1; 
																margin-top:-19px;}

.sidebar .viewproject .plusicon:hover 				{	/*background-position:left bottom;*/}																							


/*	PORTFOLIO DETAILS */

#portfolio_details_mask				{	width:960px;  overflow:visible; height:0px; padding:5px; margin-left:-5px; margin-top:-5px;margin-bottom:-5px;}
.three_fourth #portfolio_details_mask	{	width:715px;}

#portfolio_details						{	-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  
											background:<?php echo $alterego_main_color[5];?>; margin-bottom:50px;
											display:none;
										}		

.portfolio_detail_mediaholder			{	position:relative; width:470px; overflow:hidden; }		

.three_fourth #portfolio_details_mask .portfolio_detail_mediaholder	{ width:715px;}

.portfolio_detail_mediaholder img 		{	position:relative; left:0px; top:0px;  width:100%; margin-bottom:-6px; }
																									



.portfolio_detail_info_holder			{	padding:0px !important; width:490px;}
.portfolio_detail_info_holder .inlay_grey	{	padding:15px 20px 0px; background:url(../images/other/shadow_teaser_top.png) repeat-x; background-color:<?php echo $alterego_main_color[3];?>;}
.portfolio_detail_info_holder .detail_innerhtml	{	padding:20px;}

.blog .subline,
.portfolio_detail_info_holder .subline span	{	color:<?php echo $alterego_main_color[2];?>; font-size:12px;}

.portfolio_detail_info_holder .subline,
.portfolio_detail_info_holder .subline a,
.portfolio_detail_info_holder .subline a:visited {	color:<?php echo $alterego_main_color[2];?>; font-size:12px;}

.portfolio_detail_info_holder .subline a:hover	{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}


.three_fourth #portfolio_details_mask .portfolio_detail_info_holder	{	width:675px;}

.audiopreview.portfolio_detail_info_holder	{	width:100% !important;}
.audiopreview.portfolio_detail_mediaholder	{	width:960px !important;}
.three_fourth .audiopreview.portfolio_detail_mediaholder	{	width:715px !important;}

.portfolio_detail_info_holder h5,
.portfolio_detail_info_holder h5 a,
.portfolio_detail_info_holder h5 a:visited		{	margin-bottom:0px !important; color:<?php echo get_option_tree("alterego_text_color_1");?> !important;}

.portfolio_detail_info_holder h5 a:hover		{	 color:<?php echo $alterego_main_color[2];?> !important;}


.portfolio_detail_info_holder .subline span:after,
.portfolio_full_holder .subline span:after						{ content:'|'; margin-left:10px; margin-right:10px; }



.portfolio_detail_info_holder .subline span:last-child:after,
.portfolio_full_holder .subline span:last-child:after		{ content:'';margin-left:0px;}


.portfolio_detail_info_holder span a:hover	{	color:<?php echo get_option_tree("alterego_text_color_2");?>;}

.portfolio_detail_info_holder .fh-category,
.portfolio_detail_info_holder .fh-share,
.portfolio_full_holder .fh-category,
.portfolio_full_holder .fh-share 		 { margin-left:10px; margin-top:5px; padding:0px;}


.portfolio_full_holder .topline h5					{	margin-bottom:0px !important;}

.portfolio .topline, .portfolio .topline a, .portfolio .subline				{	text-align:center; }


.portfolio_navigation			{	position:relative; margin-left:20px; margin-top:20px;
									-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;}

						
.portfolio_navigation_holder	 {	position:relative; }
.tochange						 {  position:relative;}


.portfolio_close			{	float:left;  background:URL(../images/tiles/thex.png) no-repeat 7px 5px; background-color:#ababab; width:20px; height:20px;margin-right:7px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;
							}
							
.portfolio_right			{	float:left;  background:URL(../images/tiles/small_right.png) no-repeat 7px 5px; background-color:#ababab; width:20px; height:20px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;
							}
.portfolio_left			{	float:left;  background:URL(../images/tiles/small_left.png) no-repeat 6px 5px; background-color:#ababab; width:20px; height:20px;margin-right:7px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;
						}
						
.portfolio_close:hover,
.portfolio_right:hover, .portfolio_left:hover	{	background-color:#cfcfcf;}
.portfolio_right.notinuse, .portfolio_left.notinuse	{	background-color:#e5e5e5; cursor:default;}



/*	PORTFOLIO FILTER	*/
.portfolio_selector h6 			{   color:<?php echo $alterego_main_color[3];?>; padding:0px 15px 2px 15px!important;  border-right:1px solid <?php echo $alterego_main_color[3];?>;  line-height:17px;									
								}

.portfolio_selector_boss li:first-child h6	{	padding-left:0px !important; border-left:none;}
.portfolio_selector_boss li:last-child h6	{	margin-right:3px; border-right:none;}

.portfolio_selector h6:hover,	
.portfolio_filter .selected_selector h6 {   color:<?php echo get_option_tree("alterego_text_color_1");?>;}

.portfolio_filter ul li			{	float:left; font-size:12px; color:#555; position:relative;}
.portfolio_filter ul li span 	{	margin:0px 5px;}

.portfolio_filter a				{	font-weight:bold; color:#555; -webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;}




/*	SORT BY SETTINGS  */
.portfolio_sort_wrap			{	float:right; font-weight:bold; color:#555; font-size:12px; margin-bottom:20px;}
.portfolio_sotrer_form			{	float:left; position:relative;margin-left:10px; width:129px;}
.portfolio_sorter_fake			{    background:url(../images/tiles/dropdown.png) no-repeat; width:129px;height:20px; padding:0px 5px;}
.portfolio_sotrer_form select	{	position:absolute;top:0px; left:0px; width:129px;
									-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0;
									color:#555; font-size:12px;}

								
							
/*	PORTFOLIO HOVER EFFECTS	 */								
.portfolio .portfolio_link		{	 width:36px; height:37px; position:absolute; z-index:10; margin-left:-18px; margin-top:-18px; left:50%; top:50%;
									-webkit-transform: translate(100%) rotate(180deg); 	-moz-transform: translate(100%) rotate(180deg);	-o-transform: translate(100%) rotate(180deg);-ms-transform: translate(100%) rotate(180deg);
									-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0;
									-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;
								}
								
.portfolio_link .plink			{	background:url(../images/tiles/link.png) no-repeat; width:36px; height:37px;}							
								
.portfolio_link.notalone		{   margin-left:2px;}
.portfolio .portfolio_link:hover .plink { background-position:bottom;}

.portfolio .portfolio_more		{	background:url(../images/tiles/plus.png) no-repeat; width:36px; height:37px; position:absolute; z-index:10; margin-left:-18px; margin-top:-18px; left:50%; top:50%;
									-webkit-transform: translate(-100%) rotate(-180deg); -moz-transform: translate(-100%) rotate(-180deg);-o-transform: translate(-100%) rotate(-180deg);-ms-transform: translate(-100%) rotate(-180deg);
									-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0;
									-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;
								}
.portfolio_more .pmore			{	background:url(../images/tiles/plus.png) no-repeat; width:36px; height:37px;}															
								
.portfolio_more.notalone		{   margin-left:-40px;}
.portfolio .portfolio_more:hover .pmore { background-position:bottom;}
								

.portfolio ul li:hover .topline,
.portfolio ul li:hover .topline a	{	color:<?php echo $alterego_main_color[5];?>; }

.portfolio ul li.notclickable	{	cursor:default; -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=30)";	filter: alpha(opacity=30);	-moz-opacity: 0.3;	-khtml-opacity: 0.3;	opacity: 0.3;}


.portfolio ul li:hover .portfolio_link,
.portfolio ul li:hover .portfolio_more	{	-webkit-transform: translate(0%) rotate(0deg); -moz-transform: translate(0%) rotate(0deg);-o-transform: translate(0%) rotate(0deg);-ms-transform: translate(0%) rotate(0deg);
											-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";	filter: alpha(opacity=100);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1;										
										}
										
.portfolio ul li.notclickable .portfolio_link,
.portfolio ul li.notclickable .portfolio_more	{ display:none;}																			

	


.portfolio_rotator ul li	{	float:left; width:224px; margin-right:20px; background-color:<?php echo $alterego_main_color[5];?>;overflow:visible; position:relative;
								-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);
							}
.portfolio.fourcolumns >ul>li	{	width:225px; float:left; margin-right:20px; overflow:visible;}	
.portfolio.threecolumns >ul>li	{	width:306px; float:left; margin-right:20px; overflow:visible;}	
.withsidebar .portfolio.threecolumns >ul>li	{	width:225px; float:left; margin-right:20px; overflow:hidden;}	

.omega	{	margin-right:0px !important;}
.alpha	{	margin-left:0px !important; }
	   
	  

	  
	
/*********************************
	-	COMMENT LISTS	-
**********************************/

.comments						{	background-color:<?php echo $alterego_main_color[5];?>;}


.commentlist li					{  float:right;  position:relative; 	overflow:visible; border-top:1px solid #e7e7e7;padding-top:25px; margin-bottom:25px;margin-right:20px;}
.commentlist > li:first-child		{	border-top:none;}
						
.commentwrap p				{	margin-bottom:0px !important;}						

.commentwrap .posterpic		{	float:left;}						 
					  
.comments h5			{ margin-bottom:5px !important;}
.commentwrap .timestamp { font-size:14px; color:#777; margin-bottom:10px; line-height:1; }

.commentwrap .replylink a	{font-size:14px; margin-top:10px;}

.commentwrap .postertext	{	clear:both; margin-top:15px; }


.commentlist .depth-1  	{ width:94%;}
.commentlist .depth-2   { width:89%;}
.commentlist .depth-3 	{ width:84%;}
.commentlist .depth-4 	{ width:79%;}
.commentlist .depth-5  	{ width:75%;}

#commentfields .button {	line-height:20px;	}

.posterpic				{ float:left; width:40px; margin-right:20px;}
.posterpic img			{ width:100%;}
.commentwrap .replylink { position:absolute; right:0px;top:40px;}



	
	

	
/***************************************
	-	WP CORE STYLES / SHORTCODES -	
****************************************/


	.nmb	{	margin-bottom:0px !important;}
	.mb10	{	margin-bottom:10px !important}


	.space3, .divide3 	{	height:3px;}
	.space5, .divide5 	{	height:5px;}
	.space10, .divide10	{	height:10px;}
	.space10, .divide13	{	height:13px;}
	.space15, .divide15	{	height:15px;}
	.space20, .divide20	{	height:20px;}
	.space25, .divide25	{	height:25px;}
	.space30, .divide30	{	height:30px;}
	.space35, .divide35	{	height:35px;}
	.space40, .divide40	{	height:40px;}
	.space40, .divide42	{	height:42px;}
	.space45, .divide45	{	height:45px;}
	.space40, .divide50	{	height:50px;}


	
	
	.r5		{	margin-right:5px; }
	.r10	{	margin-right:10px; }
	.r15	{	margin-right:15px; }
	.r20	{	margin-right:20px; }
	
	.l5		{	margin-left:5px; }
	.l10	{	margin-left:10px; }
	.l15	{	margin-left:15px; }
	.l20	{	margin-left:20px; }
	.l25	{	margin-left:25px; }
	
	.nspace0	{	height:0px;}			/** DIRK NOCH HIER **/
	.nspace5	{	height:-5px;}
	.nspace10	{	height:-10px;}
	.nspace15	{	height:-15px;}
	.nspace20	{	height:-20px;}
	.nspace25	{	height:-25px;}
	.nspace30	{	height:-30px;}
	.nspace35	{	height:-35px;}
	.nspace40	{	height:-40px;}
	
	.w50		{	width:50px;}
	.w80		{	width:80px;}
	.w100		{	width:100px;}
	.w120		{	width:120px;}
	.w1_2		{	width:50%;}
	.w1_3		{	width:33%;}
	.w2_3		{	width:66%}

.alignnone 						{    margin: 5px 20px 20px 0;}

.aligncenter, div.aligncenter 	{    display:block;    margin: 5px auto 5px auto;}

.wp-caption 					{    background: <?php echo $alterego_main_color[5];?>;    border: 1px solid #f0f0f0;    max-width: 96%; /* Image does not overflow the content area */    padding: 5px 3px 10px;    text-align: center;}

.wp-caption.alignnone 			{    margin: 5px 20px 20px 0;	}

.wp-caption.alignleft 			{    margin: 5px 20px 20px 0;	}

.wp-caption.alignright 			{    margin: 5px 0 20px 20px;	}

.wp-caption img 				{    border: 0 none;    height: auto;    margin:0;    max-width: 98.5%;    padding:0;    width: auto;}

.wp-caption p.wp-caption-text 	{    font-size:11px;    line-height:17px;    margin:0;    padding:0 4px 5px;	}

img.size-auto,
img.size-large,
img.size-full,
img.size-medium 				{	max-width: 100%;	height: auto;}

.alignleft,
img.alignleft 					{	display: inline;	float: left;	margin-right: 20px;	margin-top: 0px;}

.alignright,
img.alignright 					{	display: inline;	float: right;	margin-left: 20px;	margin-top: 0px;}

.aligncenter,
img.aligncenter 				{	clear: both;	display: block;	margin-left: auto;	margin-right: auto;}

img.alignleft,
img.alignright,
img.aligncenter 				{	margin-bottom: 20px;}

.bordered 						{	padding: 4px;	background:#111;	border: 1px solid #1e1e1e;}

.bypostauthor {}
.sticky{}
.gallery-caption{}


.short-pdf						{	min-width:43px; height:43px; background:url(../images/icons/pdf.png) no-repeat; color:#1D78CB; font-size:12px; padding-left:53px; font-style:italic;}











/******************************
	-	BUTTONS	-
*******************************/


.purchase 				{						
							padding:8px 62px 7px 15px; border-radius: 4px; -moz-border-radius: 4px; -webkit-border-radius: 4px; height:24px; 
							background:url(../images/other/gradient/gradient_40.png) repeat-x, url(../images/other/i_purchase_2.png) no-repeat top right;						
							cursor:pointer; color:<?php echo $alterego_main_color[5];?>;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
						}
						
.purchase:hover			{	background:url(../images/other/gradient/gradient_40_hover.png) repeat-x, url(../images/other/i_purchase_2.png) no-repeat top right;}

						

.idrive 				{						
							padding:9px 62px 5px 15px; border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; height:24px;
							background:url(../images/other/gradient/gradient_40.png) repeat-x, url(../images/other/i_direction_2.png) no-repeat top right;						
							cursor:pointer;
						}
						
.idrive:hover			{	background:url(../images/other/gradient/gradient_40_hover.png) repeat-x, url(../images/other/i_direction_2.png) no-repeat bottom right;	}
						
				
					
.purchase h5 a,.purchase h5 a:visited,
.purchase a h5, .purchase a:visited h5,
.idrive h5			{  color:<?php echo $alterego_main_color[5];?>;  font-size:18px; line-height:18px;}







.button				{	padding:4px 10px 5px; border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; height:30px;						
						-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
						cursor:pointer; font-family:"PT Sans Narrow",Arial; 
						color:<?php echo $alterego_main_color[5];?> !important; font-size:15px; line-height:30px;
						background:url(../images/other/gradient/gradient_30.png) repeat-x;
					}
					
.button.big			{	color:<?php echo $alterego_main_color[5];?>; text-shadow:1px 0px 1px #606060; font-weight:500; padding:6px 15px; font-size:18px;  line-height:40px; background:url(../images/other/gradient/gradient_40.png) repeat-x;}				

.button:hover			{	background:url(../images/other/gradient/gradient_30_hover.png) repeat-x; color:<?php echo $alterego_main_color[5];?>;}
.button.big:hover		{	background:url(../images/other/gradient/gradient_40_hover.png) repeat-x; color:<?php echo $alterego_main_color[5];?>;}


/*	BUTTON COLORS	*/					

.texthighlight.black, 
.button.main_bg_color_4
.service.black,
.button.black, .button:hover.black,
.purchase.black, .purchase:hover.black,
.idrive.black, .idrive:hover.black				{ background-color:<?php echo $alterego_main_color[4];?>}

		
.texthighlight.darkgrey,
.service.darkgrey,
.button.darkgrey, .button.grey,
.button:hover.darkgrey,.button:hover.grey,
.purchase.darkgrey, .purchase:hover.darkgrey,
.idrive.darkgrey, .idrive:hover.darkgrey		{ background-color:<?php echo $alterego_main_color[3];?>;}																			


.texthighlight.lightgrey,
.service.lightgrey,
.button.lightgrey, .button:hover.lightgrey,
.purchase.lightgrey, .purchase:hover.lightgrey,
.idrive.lightgrey, .idrive:hover.lightgrey		{ background-color:<?php echo $alterego_main_color[2];?>}						

   
 .fontwhite	{	color:<?php echo $alterego_main_color[5];?> !important}

/******************************
	-	PARTNERS	-
*******************************/

	.partners				{	list-style:none; }
	.partners li			{	height:51px;margin-right:10px; float:left;padding:50px 20px 50px; position:relative;
								-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=50)";	filter: alpha(opacity=50);	-moz-opacity: 0.5;	-khtml-opacity: 0.5;	opacity: 0.5; 							
								-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;	
							}
	.partners li:hover		{
								background-color:#dcdcdc;
								-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";	filter: alpha(opacity=100);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1; 														
							}
	.partners li:hover:after	{		content: '';	position: absolute;	top: 0px;	left: 50%;	margin-left: -6px;	width: 0;	height: 0;	border-left: 6px solid transparent;	border-right: 6px solid transparent;	border-top: 6px solid <?php echo $alterego_main_color[5];?>;	}							
	
	.partners li:last-child	{	margin-right:0px;}


/******************************
	-	INPUTBOX	-
*******************************/
#search								{	float:left; margin-top:40px;  margin-left:20px;}
.headright_holder #search			{	margin-left:0px;}

.sidebar #search, .footer_container #search { margin-left:0px;margin-top:0px;}

#search .InputBox					{	width:180px;float:left; border:1px solid #ababab; background-color:<?php echo $alterego_main_color[5];?>; padding:2px 8px 2px 8px; color:#9c9fa2; font-weight:500; font-size:14px; line-height:1;  <?php echo $alterego_font_family;?>
										border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;  											
										-webkit-box-shadow:  inset 0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  inset 0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  inset 0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
									}	
#search .Button						{	float:left; position:relative; margin-left:-28px;
										width:33px;height:30px;border:none;margin-top:-3px;										
										-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
										border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;										
										background: url(../images/header/lupe.png) 1px 1px, url(../images/other/gradient/gradient_20.png) repeat-X;
										background-color: <?php echo $alterego_main_color[3];?>; /* Old browsers */								
									}
#search .Button:hover				{	cursor:pointer; background-position:1px -29px;}

 
   

#commentfields .InputBox,
#commentfields .TextBox							{	margin-top:20px; float:left;  border:1px solid #ccc; background-color:<?php echo $alterego_main_color[5];?>; padding:6px 8px 6px 8px; color:#777; font-size:13px; line-height:1;  font-family: Arial, sans-serif;}	









	
	
/*****************************************
	-	RESPONSIVE VIDEO CONTAINER	-
******************************************/


.video-container {		position: relative;		padding-bottom: 56.25%;		padding-top: 10px;	height: 0;	overflow: hidden;}


.video-wrapper {	width: 930px;		max-width: 100%;	}

.video-container iframe,  
.video-container object,  
.video-container embed {	position: absolute;	top: 0;	left: 0;	width: 100%;	height: 100%;}	

.html5video { width:930px; height:523px}
.html5audio { width:930px; height:auto;}




	


/*************************************/
/*		TEASER             			*/
/*************************************/


.tp_teaser					{	position:relative;}
.tp_teaser_rotator 			{	width:963px; margin-left:-4px; overflow:hidden; padding:3px; padding-bottom:30px;}

.sidebar .tp_teaser_rotator .insidecontainer_grey a,.sidebar .tp_teaser_rotator .insidecontainer_grey a:visited {color:<?php echo $alterego_main_color[2];?>;}

.sidebar .tp_teaser_rotator .insidecontainer_grey a,.sidebar .tp_teaser_rotator .insidecontainer_grey a:visited {color:<?php echo $alterego_main_color[2];?>;}

.one_per_page .tp_teaser_rotator	{	width:235px; margin-left:-7px; padding:3px 3px 20px 3px}
.sidebar .one_per_page .tp_teaser_rotator	{	margin-bottom:-15px;}

.tp_teaser_rotator >ul		{   width:5000px; margin-left:4px; position:relative; }
.tp_teaser_rotator >ul >li	{	float:left; width:224px; margin-right:20px; background-color:<?php echo $alterego_main_color[5];?>;overflow:visible; position:relative; 
								-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);								
							}

.tp_teaser_rotator	.stared .tp_teaser_imgholder .thegoldholder		  {	z-index:100; position:absolute; top:-1px; height:0px; background:url(../images/other/fav_corner.png) no-repeat left top;width:53px; height:53px;}							
.tp_teaser_rotator	.stared .tp_teaser_imgholder:hover .thegoldholder { background-position:left bottom; }

.extrashadow				{	-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15); }			
.extrashadow img			{	margin-bottom:-5px;}
							
.threecolumns.tp_teaser_rotator >ul >li	{	float:left; width:306px; margin-right:20px; background-color:<?php echo $alterego_main_color[5];?>;overflow:visible; position:relative;
								-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);
							}							
							
							
.tp_teaser_imgholder		{   width:225px; position:relative; }
.pp_imgholder				{    position:relative; }


.threecolumns .tp_teaser_imgholder,
.one_third .tp_teaser_imgholder					{   width:306px; position:relative; }
.withsidebar .threecolumns .tp_teaser_imgholder	{	width:224px !important;}

.tp_teaser_imgholder img 	{   top:0px; left:0px; position:relative; width:100%; -webkit-box-shadow:  0px 0px 3px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 2px 0px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 3px 0px rgba(0, 0, 0, 0.15);}

.portfolio_detail_info_holder #detail_innerhtml strong {	color:<?php echo get_option_tree("alterego_text_color_2");?>; font-weight:normal;	}

/*	THE VIEW BUTTON ON THE TEASER  */

.tp_teaser_imgholder .fullcover		{	position:absolute;top:0px; left:0px; width:100%; height:100%; background-color:<?php echo $alterego_main_color[5];?>;
										-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;	
										z-index:5;
										-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; 
									}
.hoverable .tp_teaser_imgholder:hover .fullcover  { 	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=80)";	filter: alpha(opacity=80);	-moz-opacity: 0.8;	-khtml-opacity: 0.8;	opacity: 0.8;  } 								
															
															
.tp_teaser_imgholder .viewproject	{   z-index:8;text-align:center; position:absolute;   top:50%; margin-top:20px; width:100%;										 
										-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;	
										-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; 
									}
.tp_teaser_imgholder .viewproject a	{ font-family:"PT Sans Narrow",Arial; text-align:center; padding:5px 10px; background-color:#343434; color:<?php echo $alterego_main_color[5];?>; font-size:15px; 
									  -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  
									  display:none;
									 }								
									
.hoverable .tp_teaser_imgholder:hover .viewproject	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=1)";	filter: alpha(opacity=1);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1; 
												margin-top:-10px;}
.hoverable .tp_teaser_imgholder:hover .viewproject a {display:inline}												
							

/*	THE NAVIGATION OF THE TEASER  */
.tp_teaser_navigation				{	margin-top:-41px;}
.sidebar .tp_teaser_navigation		{	margin-top:-41px;}
.footerholder .tp_teaser_navigation	{	margin-top:-47px;}
.widget_navigation					{	margin-top:-20px;}

#portfolio_details_mask .tp_teaser_navigation	{	margin-top:-44px;}

.tp_teaser_close			{	float:left;  background:URL(../images/other/nav_close.png) no-repeat; width:18px; height:18px;margin-right:-14px;position:relative;z-index:2;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15); 
							cursor:pointer;	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; }

.tp_teaser_close.showen		{	margin-right:10px;
								-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=1)";	filter: alpha(opacity=1);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1; }							

.tp_teaser_right, 
.widget_right			{	float:left;  background:URL(../images/other/nav_next.png) no-repeat; width:18px; height:18px;  position:relative;z-index:5;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15); 
							cursor:pointer;	}
							
.tp_teaser_left,
.widget_left			{	float:left;  background:URL(../images/other/nav_prev.png) no-repeat;  width:18px; height:18px;margin-right:7px; position:relative;z-index:5;
							-webkit-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        -moz-box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15);        box-shadow:  0px 0px 5px 0px rgba(0, 0, 0, 0.15); 
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							cursor:pointer;	}
						
.tp_teaser_right:hover, 
.tp_teaser_left:hover,
.widget_right:hover, 
.widget_left:hover,
.tp_teaser_close:hover		{	background-position:bottom}

.tp_teaser_right.notinuse, 
.tp_teaser_left.notinuse,
.widget_right.notinuse, 
.widget_left.notinuse	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=30)";	filter: alpha(opacity=30);	-moz-opacity: 0.3;	-khtml-opacity: 0.3;	opacity: 0.3; 
								cursor:default; background-position:top !important;}

								
/*	THE CATEGORY ON THE TEASERS  */
.tp_teaser_rotator .fh-category,
.portfolio_rotator .fh-category		{	margin-top:10px; padding:5px 20px 0px 0px;}
.portfolio_filter .fh-category		{	margin-top:15px; padding:5px 0px}




.tp_teaser_rotator .fh-share		{	margin-top:10px !important; padding:0px 20px 0px 0px !important;}
.teaser_divider			{	width:100%; background-color:#ddd; height:1px; }

.subinfo					{	padding:5px 20px; width: 150px; font-family:Arial;}
.subinfo, .siubinfo a, 
.subinfo a:visited			{	color:<?php echo $alterego_main_color[5];?>;; font-size:12px; }
.subinfo a:hover			{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}
	
/*	THE TITLE OF THE TEASER	 */
h5.teaser_title				{	padding:15px 20px 0px 20px; margin-bottom:0px !important;}
h5.teaser_teammember		{	padding:20px 20px 0px 20px; margin-bottom:0px !important;}

h5 a						{	color:<?php echo get_option_tree("alterego_text_color_2");?> !important;}

.tp_teaser_rotator p,
.portfolio_rotator p		{	padding:0px 20px; margin-bottom:0px !important;}

	
	
	
	
	
	
	
	
	
	
	
/********************************
	-	FOOTER	-
*********************************/

.footer_container h4						{	color: <?php echo get_option_tree("alterego_text_color_1");?>;line-height:1;margin-top:-4px;margin-bottom:2px !important;	}
.footer_container h5						{	margin-bottom:22px !important;	}

.subfooter_container,
.subfooter_container a,
.subfooter_container a:visited				{	color:<?php echo get_option_tree("alterego_body_background_color");?>;}
.subfooter_container a:hover				{	color:<?php echo get_option_tree("alterego_text_color_2");?>;}
.subfooter_container span:after				{	content:"|"; margin:0px 10px;}
.subfooter_container span:last-child:after	{	content:""; margin:0px 10px;}

.subfooterlogo								{	background:url(../images/footer/alterego.png) no-repeat; width:170px; height:33px;}












					
/***************************
	-	WIDGETS	-
***************************/	

h5.widgettitle				{  margin-bottom:20px !important;}





		/********************
			-	SITEMAP	-
		********************/

			
			.footersitemap >li	{	float:left; position:relative; height:20px;}
			
			.footersitemap >li >a {  color: <?php echo get_option_tree("alterego_text_color_1");?>;	padding:10px 0px; <?php echo $alterego_font_family;?>	font-weight: 400;	 font-size: 18px; line-height: 1; margin-bottom: 25px !important;
									-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;}
			.footersitemap >li:hover >a { color: <?php echo get_option_tree("alterego_text_color_2");?>;}
			
			.footersitemap .toplevelsitemap:after	{	content:'|'; margin:0px 12px;}
			.footersitemap >li:last-child:after {content:'';}
			
			.footersitemap .subs			{	 width:0px; position:absolute;display:none; }
			.footersitemap .submenus li:last-child:after{
											content: '';
											position: absolute;
											bottom: -6px;
											left: 11%;
											margin-left: -6px;
											width: 0;
											height: 0;
											border-left: 6px solid transparent;
											border-right: 6px solid transparent;
											border-top: 6px solid #0b0c0e;
										}						
			.footersitemap .submenus		{	padding:5px 9px 6px;  background-color:#0b0c0e; color:<?php echo $alterego_main_color[5];?>; left:-30px; position:absolute; z-index:100;  border-radius: 5px 5px 0px 0px; -moz-border-radius: 5px 5px 0px 0px; -webkit-border-radius: 5px 5px 0px 0px;
												-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
												left:50%;
 
											}
			.footersitemap .submenus li		{	width:174px;   height:18px; font-size:14px !important; overflow:hidden; line-height:20px; padding:5px; }			
			.footersitemap .submenus li:last-child	{	padding-bottom:11px;}
			.footersitemap .submenus li:hover a,
			.footersitemap .submenus li a:hover	{	color:<?php echo $alterego_main_color[5];?>;}
			
			
			.footersitemap li:hover .subs	{	display:block;}
		
		
		
		
		
		
		
		/********************************
			-	SKILLS	-
		*********************************/

			.skill_bg, .alert_bg		{	width:100%; background:url(../images/other/decor_inside.png) repeat; background-color:<?php echo $alterego_main_color[2];?>; height:30px; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.alert_bg					{	height:45px;}
			
			
			.skill_bg .procent			{	margin-left:10px;color:<?php echo get_option_tree("alterego_text_color_1");?>; position:relative; font-size:15px; font-family:"PT Sans Narrow",Arial; text-shadow:1px 0px 1px <?php echo $alterego_main_color[5];?>;}
			.skill.main_bg_color_4  .procent,
			.skill.main_bg_color_3  .procent			{	color:<?php echo $alterego_main_color[5];?>; text-shadow:1px 0px 1px #000;}
			
			.skill, .alert				{	background:url(../images/other/decor_inside.png) repeat;height:30px;}
			.skill						{	border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill_bg .skill_detail		{	white-space:nowrap; position:relative;padding:5px 20px; margin-left:-10px; margin-right:-10px; color:<?php echo $alterego_main_color[5];?>; text-shadow:1px 0px 1px #606060; font-size:15px; font-family:"PT Sans Narrow",Arial;}

			.skill.main_bg_color_5 .skill_detail,
			.skill.main_bg_color_2 .skill_detail			{	color:#000; text-shadow:1px 0px 1px <?php echo $alterego_main_color[5];?>;}
			
			
			
			.alert						{	text-align:center; padding-top:13px; height:32px;/* -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); */}
			.alert h5					{	color:<?php echo $alterego_main_color[5];?>; line-height:16px !important;}
			
			.alert.darkgrey h5,.alert.white h5			{	color:<?php echo get_option_tree("alterego_text_color_2");?>;}
			
			.alert 						{	text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;	}

			.skill.purple, .alert.purple	{	background-color:#c93157;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.orange, .alert.orange	{	background-color:#e43300;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.yellow, .alert.yellow	{	background-color:#f4a600;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.green, .alert.green		{	background-color:#569025;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.apple, .alert.apple		{	background-color:#91ba1e;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.blue,  .alert.blue		{	background-color:#007fb0;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.ocean, .alert.ocean		{	background-color:<?php echo $alterego_main_color[1];?>;text-shadow:1px 0px 1px #606060; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.darkgrey, .alert.darkgrey {	background-color:<?php echo get_option_tree("alterego_text_color_1");?>;text-shadow:1px 0px 1px #888; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}
			.skill.white, .alert.white 		{	background-color:<?php echo $alterego_main_color[5];?>;text-shadow:1px 0px 1px #ccc; border-radius: 3px; -moz-border-radius: 3px; -webkit-border-radius: 3px;}


			
			
			
			
			
		/********************************
			-	SUBMIT FIELDS	-
		*********************************/
		
		.inputbox								{	line-height:20px; font-size:14px; width:199px; background:#f5f5f5; border:1px solid #c0c0c0; padding:7px 10px; color:666;  color:<?php echo get_option_tree("alterego_text_color_1");?>; 
													-webkit-transition: border 0.3s, color 0.3s ease-out; -moz-transition: border 0.3s, color 0.3s ease-out; -o-transition: border 0.3s, color 0.3s ease-out; -ms-transition: border 0.3s, color 0.3s ease-in-out;
													margin-right:25px; float:left; <?php echo $alterego_font_family;?>
													border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;
													-webkit-box-shadow:  inset 0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  inset 0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  inset 0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
												}
		.inputbox.last							{	margin-right:-2px;}
		.inputbox:focus, .inputbox:hover		{	border:1px solid #c0c0c0; color:<?php echo get_option_tree("alterego_text_color_2");?>; background-color:<?php echo $alterego_main_color[5];?>;}
		
		.inputbox.textbox						{	width:97%; <?php echo $alterego_font_family;?>}
		.two_third .inputbox.textbox			{	width:94%; <?php echo $alterego_font_family;?>}
		
		.button.submit							{ 	line-height:20px; border:none; -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); }
									
		.alterego_send_button_color { background-color: <?php echo $alterego_main_color[1];?> !important;}

		.alterego_comment_send_button_color { background-color: <?php echo $alterego_main_color[1];?> !important;}
					
				


		/**********************************
			-	FLICKR WIDGET	-
		***********************************/
		.one_third .flickrwidget.one_third			{	width:28.5%; margin-right:7%; margin-bottom:5px;}	
		.one_third .flickrwidget.one_third:last		{	margin-right:0;}

		.flickrwidget .mediaholder.flickrwidget img	 		{	width:100%; cursor:pointer; border:2px solid rgba(0,0,0,0);
																-webkit-box-shadow:    0px 0px 4px 0px rgba(0, 0, 0, 0.20);;        
																-moz-box-shadow:   0px 0px 4px 0px rgba(0, 0, 0, 0.20);;        
																box-shadow:    0px 0px 4px 0px rgba(0, 0, 0, 0.20);; 		
																margin-bottom:-5px;
															}
		.flickrwidget .mediaholder.flickrwidget img:hover 	{	border:2px solid <?php echo $alterego_main_color[1];?>;  }

		.sidebar .flickrwidget .mediaholder.flickrwidget img	{	border:none;}



				
/*******************************
	-	TWITTER   -
********************************/

.twitter_container					{	position:relative; /*background:url(../images/other/shadow_testimonial_bottom.png) no-repeat bottom;*/width:304px; height:245px; margin-left:0px; overflow:visible;}
.sidebar .twitter_container 		{	background:none; position:relative; width:324px; height:170px; margin-left:0px; overflow:visible;}
.footerholder .twitter_container	{	background:none; position:relative; width:310px; height:170px; margin-left:0px; overflow:visible;}

.twitter_newpage					{	background:<?php echo $alterego_main_color[2];?>; position:absolute; top:0px; left:0px;  width:264px; height:185px; padding:20px;}
.sidebar .twitter_newpage			{	background:none; position:absolute; top:0px; left:0px;  width:224px; height:170px; padding:0;}
.footerholder .twitter_newpage		{	background:none; position:absolute; top:0px; left:0px;  width:310px; height:170px; padding:0;}

.twitter_reader_list 		{	height:180px; overflow:visible; visibility:hidden;}

.twitter_reader_quote		{	display:none; }

.twitter_reader_list li,
.twitter_reader_list ul,
.twitter_reader_list li ul { list-style:none;}

.twitter_reader_list li 	{	list-style-type:none;	color:<?php echo $alterego_main_color[3];?>; text-align: left;	margin-bottom: 20px; padding-left: 0px; height:80px; font-size:12px; line-height:19px; font-family:Arial;}
.sidebar .twitter_reader_list li {	list-style-type:none;	color:<?php echo $alterego_main_color[3];?>; text-align: left;	margin-bottom: 20px; padding-left: 0px; height:80px; font-size:12px; line-height:19px; font-family:Arial;}

/* Last LI element in column has no dividing line build by border-bottom */
.twitter_reader_list li:last-child { margin-bottom:0px;}

.twitter_reader_list li a,
.twitter_reader_list li a:visited	{	text-decoration: none; color:<?php echo $alterego_main_color[1];?>; }
.twitter_reader_list li a:hover		{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}


.twitter_reader_list span	{	color:<?php echo get_option_tree("alterego_text_color_1");?>; font-size:11px;}


/*	THE NAVIGATION OF THE TEASER  */
.tp_twitter_navigation			{	margin-top:-41px;}
.footerholder .tp_twitter_navigation	{	margin-top:-47px;}
.sidebar .tp_twitter_navigation	{ 	margin-top:-41px;}
.tp_twitter_right			{	float:left;  background:URL(../images/other/nav_next.png) no-repeat; width:18px; height:18px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;	}
							
.tp_twitter_left			{	float:left;  background:URL(../images/other/nav_prev.png) no-repeat;  width:18px; height:18px;margin-right:7px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;	}
						
.tp_twitter_right:hover, 
.tp_twitter_left:hover		{	background-position:bottom}

.tp_twitter_right.notinuse, 
.tp_twitter_left.notinuse	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=30)";	filter: alpha(opacity=30);	-moz-opacity: 0.3;	-khtml-opacity: 0.3;	opacity: 0.3; 
								cursor:default; background-position:top !important;}






/*******************************
	-	CONTENT ROTATOR   -
********************************/

.rotator_container			{	position:relative;/* background:url(../images/other/shadow_testimonial_bottom.png) no-repeat bottom;*/width:304px; height:230px; margin-left:0px; overflow:visible;}


.rotator_shortcode_newpage			{	background:<?php echo $alterego_main_color[2];?>; position:absolute; top:0px; left:0px;  width:264px; height:170px; padding:20px;}

.rotator_shortcode li,
.rotator_shortcode ul,
.rotator_shortcode li ul { list-style:none;}

.rotator_shortcode li 	{	list-style-type:none;	color:<?php echo $alterego_main_color[3];?>; text-align: left;	margin-bottom: 20px; padding-left: 0px; height:80px; font-size:12px; line-height:19px; font-family:Arial;}

.rotator_shortcode li h5 {  color:<?php echo get_option_tree("alterego_text_color_1");?>; line-height:27px; margin-bottom:0px !important;}

/* Last LI element in column has no dividing line build by border-bottom */
.rotator_shortcode li:last-child { margin-bottom:0px;}

.rotator_shortcode a		{	text-decoration: none; color:<?php echo $alterego_main_color[1];?> !important;}
.rotator_shortcode a:hover	{	color:<?php echo get_option_tree("alterego_text_color_1");?> !important;}

.rotator_shortcode .testimonail_head	{	padding-left:46px; background:url(../images/other/i_testimonial.png) no-repeat top left; }
.rotator_shortcode .testimonail_head h5	{	line-height:13px; margin-bottom:5px !important;}
.rotator_shortcode .testimonial_content	{	margin-top:10px;}


/*	THE NAVIGATION OF THE TEASER  */
.tp_rotator_navigation		{	margin-top:-41px;}

.tp_rotator_right			{	float:left;  background:URL(../images/other/nav_next.png) no-repeat; width:18px; height:18px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;	}
							
.tp_rotator_left			{	float:left;  background:URL(../images/other/nav_prev.png) no-repeat;  width:18px; height:18px;margin-right:7px;
							-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); 
							cursor:pointer;	}
						
.tp_rotator_right:hover, 
.tp_rotator_left:hover		{	background-position:bottom}

.tp_rotator_right.notinuse, 
.tp_rotator_left.notinuse	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=30)";	filter: alpha(opacity=30);	-moz-opacity: 0.3;	-khtml-opacity: 0.3;	opacity: 0.3; 
								cursor:default; background-position:top !important;}


								
								
								

/*******************************
	-	PRE	-	
********************************/
pre {
		
		
		 font-size:12px;
		 color:<?php echo $alterego_main_color[3];?>;
		 background:url(../images/other/bg_code.png) repeat;
		 line-height:17px;
		 border:1px solid #ecf0f1;
		 white-space: pre-wrap;       /* css-3 */
		 white-space: -moz-pre-wrap;  /* Mozilla, since 1999 */
		 white-space: -pre-wrap;      /* Opera 4-6 */
		 white-space: -o-pre-wrap;    /* Opera 7 */
		 word-wrap: break-word;       /* Internet Explorer 5.5+ */
		 padding:20px;
}	






/***********************
	-	BANNER	-
************************/	


		/*	-	THE BANNER CONTAINER (Padding, Shadow, Border etc. )	-	*/
		.bannercontainer{
			width:960px;	
			margin-top:12px;
			margin-left:0px;
			position:relative;		
			
		}

		.homebanner.bannercontainer	{	height:100%; background:url(../images/other/decor_inside.png) repeat; }
		
		.homebanner_inner_shadow {
			width:100%; height:22px;background:url("../images/other/shadow_pattern_slider_bottom.png") repeat-x bottom;width:960px;
			bottom:0px;
			z-index:200;
			position:absolute;
			
		}


		.portfolio_detail_mediaholder .bannercontainer	{	margin-top:0px;}

		.bannerfooter	 {	background-color:<?php echo $alterego_main_color[2];?>; width:960px; height:65px; border-radius: 0px 0px 5px 5px; -moz-border-radius: 0px 0px 5px 5px; -webkit-border-radius: 0px 0px 5px 5px; height:65px; overflow:hidden;}
		.bannerfooter h3 { color:<?php echo get_option_tree("alterego_text_color_1");?>; padding:15px 20px 20px;}
		.bannerfooter .hordiv h5 { background:url(../images/other/separator_banner_bottom.png) repeat-y; min-width:14px; padding:22px 20px 25px; height:100%; color:<?php echo $alterego_main_color[3];?>;}
		.bannerfooter .purchase	{	margin-top:14px;margin-right:20px;}


		.bannerbuttonholderleft   {	  width:61px; height:30px; position:relative;}
		.bannerbuttonholderright  {	  width:61px; height:30px; position:relative;}

		.portfolio_detail_mediaholder .bannerbuttonholderleft,
		.portfolio_detail_mediaholder .bannerbuttonholderright	{	visibility:hidden;}

		.bannerbuttonholderleft .bannerbutton			
							{	position:relative; width:61px; height:30px;						
								background: url(../images/other/prev_slider.png) no-repeat top left;					
								cursor:pointer;						
								background-color:/*<?php echo $alterego_main_color[3];?>;*/ #b9b9b9;
							}
						
		.bannerbuttonholderright .bannerbutton		
							{	position:relative; width:61px; height:30px;						
								background: url(../images/other/next_slider.png) no-repeat top left, url("../images/other/shadow_pattern_slider_bottom.png") repeat-x bottom;					
								cursor:pointer;						
								background-color:/*<?php echo $alterego_main_color[3];?>;*/ #b9b9b9;
							}

		.bannerbutton			{	-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  }
		.bannerbuttonholderleft:hover .bannerbutton,
		.bannerbuttonholderright:hover .bannerbutton	{	left:0px;	}				

		#bannerleft:hover	{	background-position:  0px -1px;}
		#bannerright:hover	{	background-position:  0px 1px, bottom;}

		#bannerleft:active,
		.bannerbutton:active	{	background-position:  0px -30px;}

		#bannerright:active,
		.bannerbutton:active	{	background-position:  0px -28px,bottom;}


		/*	-	THE BANNER	(max-width)	-	*/
		.banner{
			width:960px;
			height:100%;
			position:relative;
			overflow:hidden;			
			-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0;
		}

		.bannertimer{
			background:#1D78CB;
			height:2px;
			width:100%;
			position:absolute;
			top:0px;	
			z-index:25;
			/*border-top:1px solid <?php echo get_option_tree("alterego_text_color_2");?>;
			border-right:1px solid <?php echo get_option_tree("alterego_text_color_2");?>;
			border-bottom:1px solid <?php echo get_option_tree("alterego_text_color_1");?>;
			border-left:1px solid <?php echo get_option_tree("alterego_text_color_1");?>;
			-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=50)";	filter: alpha(opacity=50);	-moz-opacity: 0.5;	-khtml-opacity: 0.5;	opacity: 0.5;*/
		}


		.navigationbox						{	float:left;  z-index:300; position:relative;background:url("../images/other/shadow_pattern_slider_bottom.png") repeat-x bottom; background-color:<?php echo $alterego_main_color[3];?>; width:306px; height:100%;margin-right:20px;}
		.bstyle-thumbs .navigationbox		{	width:60px;}
		.bstyle-none .navigationbox			{	display:none;}
		.bstyle-ab .navigationbox			{	width:245px; margin-right:0px;}
	
		.homebanner	.bannerdecor			{	float:right; width:633px;  position:relative;}
		.bstyle-thumbs.homebanner .bannerdecor	{ width:880px !important;}
		.bstyle-none.homebanner .bannerdecor	{ width:960px !important;}
		.bstyle-ab.homebanner .bannerdecor		{ width:715px !important; float:left;}
		
		
		.bannerslogans						{	float:left; width:245px;}
		.bstyle-thumbs .bannerslogans		{	width:0px; display:none;}
		
		.teasertext							{	width:205px; height:100%;padding:20px;}
		.teasertext .thumbtitle				{	font-size:61px; color:<?php echo $alterego_main_color[5];?>; line-height:1; font-family:"PT Sans Narrow"; }
		.teasertext .thumbdescription		{	font-size:20px; color:<?php echo get_option_tree("alterego_text_color_1");?>; font-family:"PT Sans Narrow"; padding-top:20px;}

		.bannernavholder			{	position:relative; height:370px; width:61px;float:right; overflow:visible;
										/*-webkit-box-shadow: 0px 0px 3px -1px #000;-moz-box-shadow: 0px 0px 3px -1px #000; box-shadow: 0px 0px 3px -1px #000; */
									}
		.bstyle-thumbs	.bannernavholder	{ float:left;}
		.bstyle-ab		.bannernavholder	{ display:none;}
		

		.thumbsholder				{	position:relative; overflow:visible; height:100%; width:68px;}
		.thumbsholder .bullet		{	width:68px;height:62px; cursor:pointer; overflow:hidden; position:relative;}

		.thumbsholder .bullet .imagemask	{	width:61px; height:62px; overflow:hidden; background:url(../images/other/thumbnail_gradient.png);}

		.thumbsholder .bullet .cover		{	background-color:<?php echo $alterego_main_color[1];?>; width:61px; height:62px; position:absolute; z-index:2;top:0px;left:0px;
												-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0;
												-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
												}
		.thumbsholder .bullet img	{	height:100%;}

		.thumbsholder .bullet:hover .cover	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=75)";	filter: alpha(opacity=75);	-moz-opacity: 0.75;	-khtml-opacity: 0.75;	opacity: 0.75;}
		.thumbsholder .bullet.selected .cover	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=75)";	filter: alpha(opacity=75);	-moz-opacity: 0.75;	-khtml-opacity: 0.75;	opacity: 0.75;}


		.thumbsholder .bullet.selected .imagemask:after	{	 z-index:40; position:absolute; content: '';	top: 50%;	left:61px;	margin-top: -6px;	width: 0;	height: 0;	border-top: 6px solid transparent;	border-bottom: 6px solid transparent;	border-left: 6px solid <?php echo $alterego_main_color[1];?>;	}



		.navigationbox  .tp-thumbs						{	width:70px;height:100%; z-index:100; position:absolute; }
													
		.navigationbox  .tp-thumbs .tp-mask				{	height:100%; width:70px;  overflow:hidden; position:relative;}

		.navigationbox  .tp-thumbs .tp-mask .tp-thumbcontainer	{	height:5000px; width:100%; position:absolute;}


		.homebanner_shadow		{	background:url(../images/other/shadow_slider_bottom.png); width:960px; height:40px;}



		.tp-simpleresponsive ul {
			list-style:none;
			padding:0;
			margin:0;
		}			

		.tp-simpleresponsive >ul li{
			list-stye:none;			
			position:absolute;
		}

		.tp-simpleresponsive .caption {
			-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; position:absolute;
		}


		.simplebannerbuttons {	 cursor:pointer; width:56px; height:58px; position:absolute; z-index:400; top:50%; margin-top:-25px;}
		.bbleft				 {	 background:url(../images/other/slide_navscroll_prev.png) no-repeat top left; left:20px;}
		.bbright			 {	 background:url(../images/other/slide_navscroll_next.png) no-repeat top left; right:20px;}
					
		.simplebannerbuttons:hover	{	background-position:bottom left; }
		
		
		
/************************
	-	BULLETS	-
*************************/

.tp-roundbullets				{	z-index:1000; margin-left:auto; margin-right:auto;  position:relative; margin-top:-20px; background:url(../images/assets/button/navigdots_bgtile.png); height:17px;	 
									padding:9px 9px; 
									border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;  	
									-webkit-box-shadow: 0px 0px 16px -1px #000;-moz-box-shadow: 0px 0px 16px -1px #000; box-shadow: 0px 0px 16px -1px #000; 
								}
								

.tp-longbullets					{	z-index:1000; margin-left:auto; margin-right:auto;  position:relative; margin-top:0px; 	 width:800px; }	
.tp-longbullets .bullet			{	position:relative;width:100px; border:1px solid #ccc; border-top:5px solid #ccc; float:left; margin-right:-1px; text-align:center; padding:10px 0px 10px 0px;
									backgrounc:<?php echo $alterego_main_color[5];?>;
									/*-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;*/
								}	
.tp-longbullets .bullet-first	{	border-left:none; }
.tp-longbullets .bullet.last	{	border-right:none; }

.tp-longbullets	.btitle			{	color:#000; font-size:12px; line-height:1; font-weight:700; font-family: sans-serif; position:relative; font-family: Arial, sans-serif;	}
.tp-longbullets	.bdesc			{	margin-top:5px; color:#666; font-size:11px; line-height:1; font-style:italic; font-family: Arial; position:relative; }
							
							

.tp-longbullets .bullet:hover,
.tp-longbullets .bullet.selected		{	border-top:5px solid #1D78CB; background:#f5f5f5; cursor:pointer;}
	


.tp-roundbullets .bullet				{	cursor:pointer; position:relative;
											background:url(../images/assets/button/navigdots.png) no-Repeat bottom left;	width:15px;	height:15px; border-radius: 8px; -moz-border-radius: 8px; -webkit-border-radius: 8px; margin-right:10px; float:left;
											-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.8s ease-out; -ms-transition: all 0.3s ease-in-out;
											border:1px solid #373737;
										}

.tp-roundbullets .bullet:last-child		{	margin-right:0px;	}

.tp-roundbullets .bullet:hover, 
.tp-roundbullets .bullet.selected		{	background-position:top left; }


/**		BULLET THUMBS VERSION	**/

.tp-roundbullets .bulletthumbs						{	display:none; position:absolute;  top:-90px; padding:3px; background-color:<?php echo $alterego_main_color[5];?>;
														-webkit-box-shadow: 0px 0px 3px -1px #000;-moz-box-shadow: 0px 0px 3px -1px #000; box-shadow: 0px 0px 3px -1px #000;
													}
.tp-roundbullets .bulletthumbs .smallarrow			{	margin-left:-4px; width:9px; height:5px; z-index:10; position:absolute; bottom:-5px; left:50%; background:url(../images/assets/button/arrowdown.png) no-repeat 0px 0px; }
.tp-roundbullets .bulletthumbs .thumbdecorholder	{   position:relative; top:0px; left:0px; width:120px; height:70px; overflow:hidden; }
.tp-roundbullets .bulletthumbs .thumbsholder		{	position:relative;  top:0px; left:0px; width:5000px; }
.tp-roundbullets .bulletthumbs .bulletthumb			{	float:left; width:120px; height:70px;}


.tp-longbullets .bulletthumbs						{	display:none; position:absolute;  top:-90px; padding:0px; background-color:<?php echo $alterego_main_color[5];?>;
														-webkit-box-shadow: 0px 0px 3px -1px #000;-moz-box-shadow: 0px 0px 3px -1px #000; box-shadow: 0px 0px 3px -1px #000;
													}

.tp-longbullets .bulletthumbs .thumbdecorholder		{   position:relative; top:0px; left:0px; width:120px; overflow:hidden; }
.tp-longbullets .bulletthumbs .thumbsholder			{	position:relative;  top:0px; left:0px;  width:5000px;}
.tp-longbullets .bulletthumbs .bulletthumb			{	float:left; width:120px; height:70px;}


.caption p											{	font-size:18px;}

	



.bulletholder			{	position:absolute; z-index:1000; height:7px; background-color:<?php echo $alterego_main_color[5];?>;padding-top:12px;}
.bulletholder .bullet	{	float:left; width:7px; height:7px; background:url(../images/other/list_3.png) no-repeat; margin-right:10px;
							cursor:pointer;
							/* Firefox */
									-moz-transition: all 0.3s ease;
									/* WebKit */
									-webkit-transition: all 0.3s ease;
									/* Opera */
									-o-transition: all 0.3s ease;
									/* Standard */
									transition: all 0.3s ease;
									-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=50)";	filter: alpha(opacity=50);	-moz-opacity: 0.5; 	-khtml-opacity: 0.5;	opacity: 0.5; 
						}

.bulletholder .bullet:hover,
.bulletholder .bullet.selected	{	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";	filter: alpha(opacity=100);	-moz-opacity: 1; 	-khtml-opacity: 1;	opacity: 1; }					
							
.bulletholder .bullet.last	{	margin-right:0px;}
	
	
	
	
	
/************************************
	-	CONTENT SHORTCODES	-
************************************/
	
	.contentdivider { width: 100%; height: 0; border-bottom: 1px solid #ddd; margin-bottom: 20px; }
	.one_half { width: 49%; }
	.one_third { width: 31.9%; }
	.two_third { width: 65.8%; }
	.three_fourth { width:74.5%;}
	.one_fourth { width: 23.5%; }
	.four_fifth { width:80%;}
	.five_sixth { width:84.6%;}
	
	.one_fifth { width: 18%; }
	.one_sixth { width: 13.33%; }
	.one_half, .one_third, .two_third, .one_fourth, .one_fifth, .one_sixth, .three_fourth, .four_fifth, .five_sixth { margin-right: 2%; float: left; }
	
		.sidebar .one_third	{	width:66px !important; margin-right:13px;}
		.sidebar .one_third	{	width:66px !important; margin-right:13px;}
		
		
	
	
	
	.lastcolumn { margin-right: 0!important; clear: right; }


	@media only screen and (max-width: 767px) {
		.one_half, .one_third, .two_third, .one_fourth, .one_fifth, .one_sixth { width: 100%; }
	}
	
	
	
	
	
	
/************************************
		-	PRICETABLES	-
*************************************/


	.pricecol		{	}
	.pricecol ul	{	float:left; font-weight:500; border-bottom:1px solid <?php echo $alterego_main_color[2];?>;}
	
	.pricecol:first-child ul	{	border-left:1px solid <?php echo $alterego_main_color[2];?>;} 
	.pricecol:last-child ul		{	border-right:1px solid <?php echo $alterego_main_color[2];?>;}
	.pricing.fourcols .pricecol:last-child ul	{	border-right:none;}
	.pricing.fivecols .pricecol:last-child ul	{	border:none;}
	.pricing.fivecols .pricecol:first-child ul	{	border:none;}
	
/*	-webkit-box-shadow:  0px 0px 8px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 8px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 8px 0px rgba(0, 0, 0, 0.20);}*/

	
	.pricecol p		{ 	margin-bottom:0px !important;}
	
	.pricing.fivecols .pricecol	ul { overflow:visible; width:19.8%; }
	.pricing.fourcols .pricecol	ul { overflow:visible; width:24.8%; }
	.pricing.threecols .pricecol ul { overflow:visible; width:33.1%; }
	
	.pricecol ul li	{	background-color:<?php echo $alterego_main_color[5];?>; margin-bottom:0px;}
	.pricing.fourcols .pricecol:nth-child(even) ul li {	background-color:<?php echo $alterego_main_color[2];?>;}
	.pricing.fourcols .pricecol:nth-child(even) ul { border-bottom:none; background:url(../images/other/shadow_teaser_bottom.png) repeat-x bottom; padding-bottom:20px;margin-bottom:-20px; }
	
	.pricing.fivecols .pricecol:nth-child(odd) ul li {	background-color:<?php echo $alterego_main_color[2];?>;}
	.pricing.fivecols .pricecol ul { border-bottom:none; background:url(../images/other/shadow_teaser_bottom.png) repeat-x bottom;background-size:98%; padding-bottom:15px;margin-bottom:-15px; }
	
	
	

	.pricing.threecols .pricecol:nth-child(even) ul li {	background-color:<?php echo $alterego_main_color[5];?>;}
	.pricing.threecols .pricecol:nth-child(odd) ul li  {	background-color:<?php echo $alterego_main_color[2];?>;}
	
	.pricing.fivecols .pricecol:nth-child(odd) ul li {	background-color:<?php echo $alterego_main_color[2];?>;}
	.pricing.fivecols .pricecol:nth-child(even) ul li {	background-color:<?php echo $alterego_main_color[5];?>;}
	
	.pricecol h2, .pricecol h3		{	margin-bottom:0px !important;}
	.pricing .pricecol .thead h3 	{	color:<?php echo $alterego_main_color[2];?>; line-height:1; padding:25px 0px; text-align:center;width:100%; background:url(../images/other/decor_inside.png) repeat; background-color:<?php echo $alterego_main_color[3];?>;}
	
	
	.pricing.fivecols .pricecol:nth-child(even) .thead h3,
	.pricing.fourcols .pricecol:nth-child(even) .thead h3,
	.pricing.threecols .pricecol:nth-child(even) .thead h3	{  background-color:<?php echo $alterego_main_color[1];?>;	}
	
	.pricing .pricecol .price h1	{	font-size:36px !important;}
	.pricing .pricecol .price		{	 text-align:center; padding:10px 0px 0px; color:<?php echo $alterego_main_color[1];?>;}
	.pricing.threecols .pricecol:nth-child(odd) .price,
	.pricing.fivecols .pricecol:nth-child(odd) .price	{ color:#000 !important;}
	.pricing.threecols .pricecol:nth-child(odd) .price_sub,
	.pricing.fivecols .pricecol:nth-child(odd) .price_sub	{ border-bottom:2px solid <?php echo $alterego_main_color[5];?> !important;}
	
	.pricing .pricecol .price h1,
	.pricing .pricecol .price h2,
	.pricing .pricecol .price h3,
	.pricing .pricecol .price h4,
	.pricing .pricecol .price h5	{ 	 margin-bottom:0px !important;}
	.pricing .pricecol .price_sub	{	 text-align:center; padding-bottom:10px; border-bottom:2px solid <?php echo $alterego_main_color[2];?>; color:<?php echo $alterego_main_color[3];?>;}	
	.pricing.fourcols .pricecol:nth-child(even) .price_sub	{	border-bottom:2px solid <?php echo $alterego_main_color[3];?>;}
	.pricing.fivecols .pricecol:nth-child(odd) .price_sub	{	border-bottom:2px solid <?php echo $alterego_main_color[3];?>;}
	
	.pricing .pricecol .item		{	 padding:15px 25px;   text-align:center;}	
	.pricing .pricecol .buy			{	 text-align:center;  padding:10px 0px 25px; }
	

	
	
	
	
	
/*	.pricecol.highlight ul			{	-webkit-box-shadow:  0px 0px 8px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 8px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 8px 0px rgba(0, 0, 0, 0.20);										}
*/
									
	.pricing.threecols .pricecol.highlight ul  {	border-bottom:none; background:url(../images/other/shadow_team3_bottom.png) no-repeat bottom; padding-bottom:25px;margin-bottom:-25px;	 }
	.pricing.fourcols .pricecol.highlight ul   {	border-bottom:none;background:url(../images/other/shadow_teaser_bottom.png) no-repeat bottom; background-size:100%; padding-bottom:20px;margin-bottom:-20px;	 }
	.pricing.fivecols .pricecol.highlight ul   {	border-bottom:none;background:url(../images/other/shadow_teaser_bottom.png) no-repeat bottom; background-size:80%; padding-bottom:20px;margin-bottom:-20px;	 }	
									
									
	.pricecol.highlight .buy		{  padding:15px 0px 30px 0px;}
	.pricing.fivecols .pricecol.highlight ul		{	width:19.9% !important; margin-top:-11px;position:relative;z-index:2; }													
	.pricing.fourcols .pricecol.highlight ul		{	width:24.8% !important; margin-top:-11px;position:relative;z-index:2; }														
	.pricing.threecols .pricecol.highlight ul		{	width:32.9% !important; margin-top:-11px;position:relative;z-index:2; }															
								

	
	
	.large-button-wrap		{	}
	.large-button							{	filter: dropshadow(color=<?php echo get_option_tree("alterego_text_color_2");?>333, offx=0, offy=1);	font-weight:700; font-family: 'PT Sans Narrow', sans-serif, Helvetica, Arial, sans-serif;
													 border-radius: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; 													 
													 max-height:41px; padding:11px 20px 12px;
													 -webkit-transition: all 0s ease-out; -moz-transition: all 0s ease-out; -o-transition: all 0s ease-out; -ms-transition: all 0.3s ease-in-out;
											}
											
    .large-button span						{	color:<?php echo $alterego_main_color[5];?>;	text-shadow:1px 0px 1px #606060; font-size:15px;  }							
	
	.orange.large-button					{ 	background:url(../images/tiles/largebutton_orange.png) no-repeat top left; }
	.green.large-button						{ 	background:url(../images/tiles/largebutton_green.png) no-repeat top left; }
	.apple.large-button						{ 	background:url(../images/tiles/large_button_apple.png) no-repeat top left; }
	.blue.large-button, .large-button		{ 	background:url(../images/tiles/large_button.png) no-repeat top left; }
	.red.large-button						{ 	background:url(../images/tiles/large_button_red.png) no-repeat top left; }
	.lightgrey.large-button					{ 	background:url(../images/tiles/largebutton_lightgrey.png) no-repeat top left; }
	.darkgrey.large-button					{ 	background:url(../images/tiles/largebutton_darkgrey.png) no-repeat top left; }
	.candy.large-button						{ 	background:url(../images/tiles/largebutton_candy.png) no-repeat top left; }
	.yellow.large-button					{ 	background:url(../images/tiles/largebutton_yellow.png) no-repeat top left; }

	.large-button:hover			{	background-position:0px -42px;}

	
	
 
 
 /************************************
	-	content Accordion	-
***************************************/
			.contentsc.accordion 								{	border-top:1px solid #bbb;border-left: 1px solid #bbb;border-right: 1px solid #bbb;
																/*	-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  */
																}
			.contentsc.accordion.noborder						{	border:none; 
																	-webkit-box-shadow:  none;        
																	-moz-box-shadow:  none;        
																	box-shadow:  none;  
																}
		
				
			
			.contentsc.accordion .toggleswitch					{	margin-left:5px; cursor:pointer;  padding-left:25px; height:25px; padding-top:0px; }
			.ocean .toggleswitch								{	background:url(../images/other/nav_faq_1.png) no-repeat top left; }
			.apple .toggleswitch								{	background:url(../images/other/nav_faq_2.png) no-repeat top left; }
			.orange .toggleswitch								{	background:url(../images/other/nav_faq_4.png) no-repeat top left; }
			.purple .toggleswitch								{	background:url(../images/other/nav_faq_5.png) no-repeat top left; }
			.darkgrey .toggleswitch								{	background:url(../images/other/nav_faq_6.png) no-repeat top left; }
			.lightgrey .toggleswitch							{	background:url(../images/other/nav_toggles_plus.png) no-repeat top left; }
			
			
			.contentsc.accordion .toggleswitch.selected				{  background-position:bottom left;}
			.lightgrey:hover .toggleswitch							{  background-position:bottom left;}
			.contentsc.accordion .lightgrey .toggleswitch.selected		{  background:url(../images/other/nav_toggles_minus.png) no-repeat top left; }
			.contentsc.accordion .lightgrey:hover .toggleswitch.selected		{  background-position:bottom left;}
			
			.contentsc.accordion .accordion-item				{   width:100%;  position:relative; background:<?php echo $alterego_main_color[2];?>; padding:15px 0px;
																	-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;
																}
			.contentsc.accordion.noborder .accordion-item		{	background:transparent;}
			.contentsc.accordion .accordion-item				{	border-bottom:1px solid #bbb;}
			
			.contentsc.accordion.noborder .accordion-item:last-child	{	border-bottom:none;}

			.contentsc.accordion .accordion-item .toggletitle	{	  margin-left:10px;   
																	-webkit-transition: all 0.3s ease-out; -moz-transition: all 0.3s ease-out; -o-transition: all 0.3s ease-out; -ms-transition: all 0.3s ease-in-out;
																}
																

			.contentsc.accordion .accordion-item .toggletitle h5 {	margin-bottom:0px !important;}
			
			.contentsc.accordion .accordion-item.highlight .toggletitle	{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}
			.contentsc.accordion .accordion-item.highlight				{	background-color:<?php echo $alterego_main_color[5];?>;}
			.contentsc.accordion.noborder .accordion-item.highlight		{	background:transparent;}
			

			.contentsc.accordion .togglecontent				{	border:none; padding:10px 20px 0px 25px; margin-bottom:0px;}			
			
			
			
			.contentsc.accordion .togglecontent	p			{	margin-bottom:0px !important; color:<?php echo get_option_tree("alterego_text_color_1");?>;}			
			.contentsc.accordion.noborder p					{	color:<?php echo $alterego_main_color[3];?>;}
			.contentsc.accordion .accordion_down:hover		{	background-color:#373737;}		

			.contentsc.accordion							{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}
			.contentsc.accordion p							{	font-size:12px; color:<?php echo $alterego_main_color[3];?>; font-family:Arial; margin-left:-15px;}		
			
			.contentsc.accordion.noborder p					{ 	color:<?php echo get_option_tree("alterego_text_color_1");?>;}
			.contentsc.accordion.noborder a					{	color:<?php echo get_option_tree("alterego_text_color_2");?>;}
			.contentsc.accordion.noborder a:hover			{	color:<?php echo $alterego_main_color[1];?>;}
			
			
			.contentsc.accordionopen						{	cursor:pointer;}	
			
			
			.contentsc.accordion .tp-check				{	padding-left:51px;}	
			.contentsc.accordion .tp-support			{	padding-left:51px;}	
			.contentsc.accordion .tp-global				{	padding-left:51px;}	
			.contentsc.accordion .tp-modular			{	padding-left:51px;}	
			.contentsc.accordion .tp-team				{	padding-left:51px;}	
			.contentsc.accordion .tp-alert				{	padding-left:51px;}	
			.contentsc.accordion .tp-cart				{	padding-left:51px;}	
					
				


				
	
/******************************
	-	TABS	-
*******************************/

/* #Tabs (activate in tabs.js)
================================================== */
ul.tabs 			{		display: block;		margin: 0 0 20px 0;		padding: 0;		border-bottom: solid 1px #bec0bf; 		border-top: 0 !important;		}
ul.tabs li 			{		display: block;		width: auto;		height: 30px;		padding: 0 !important;		float: left;				margin-bottom: 0 !important; 		border-bottom:0 !important;}		
ul.tabs li a 		{		display: block;		text-decoration: none;		width: auto;		height: 29px;		padding: 0px 20px;		line-height: 30px;		border: solid 1px #bec0bf;		border-width: 1px 1px 0 0;		margin: 0;		
							background-color: <?php echo $alterego_main_color[2];?>;		font-size: 15px; 		color:<?php echo get_option_tree("alterego_text_color_1");?>;				
							font-family:'PT Sans Narrow', Arial;
					}
ul.tabs li:hover a {		background:<?php echo $alterego_main_color[5];?>;}

ul.tabs li a.active {		background: <?php echo $alterego_main_color[5];?>;		height: 35px;		position: relative;		top: -5px;		padding-top: 5px;		border-left-width: 1px;		margin:0;		margin-top:-5px;
							margin-left:-1px;		color: <?php echo get_option_tree("alterego_text_color_1");?>;		}
ul.tabs li:first-child a.active {		margin-left: 0; }

ul.tabs li:first-child a {		border-width: 1px 1px 0 1px;		}

		
ul.tabs li:last-child a {		 }

ul.tabs-content { margin: 0; display: block; border-top:0 !important; }
ul.tabs-content > li { display:none; }
ul.tabs-content > li.active { display: block; border-bottom:0 !important; }

	/* Clearfixing tabs for beautiful stacking */
ul.tabs:before,
ul.tabs:after 		{	  content: '\0020';	  display: block;	  overflow: hidden;	  visibility: hidden;	  width: 0;	  height: 0; }
ul.tabs:after 		{	  clear: both; }
ul.tabs 			{	  zoom: 1; }
	
			
			
			
			
			
			
/***************************
	  - 	LISTS	-
***************************/


ul.style1{	list-style-image:url(../images/other/list_1.png); margin-left:15px; font-size:12px;line-height:17px; color:<?php echo $alterego_main_color[3];?> }	  
ul.style2{	list-style-image:url(../images/other/list_2.png); margin-left:15px; font-size:12px;line-height:17px; color:<?php echo $alterego_main_color[3];?> }
ul.style3{	list-style-image:url(../images/other/list_3.png); margin-left:15px; font-size:12px;line-height:17px; color:<?php echo $alterego_main_color[3];?> }

ul.style1 ul,  ul.style2 ul, ul.style3 ul { margin-left: 15px; }

ul.style1 li, 
ul.style2 li, 
ul.style3 li		{	padding:1px 4px; cursor:pointer;} 


ul.style1 li:hover >span, 
ul.style2 li:hover >span, 
ul.style3 li:hover >span { color:#f4f3f2; background-color:<?php echo $alterego_main_color[1];?>; padding:1px 4px; border-radius: 2px;   -moz-border-radius: 2px;   -webkit-border-radius: 2px; }	

ul.style1.grey li:hover >span, 
ul.style2.grey li:hover >span, 
ul.style3.grey li:hover >span { color:<?php echo $alterego_main_color[2];?>; background-color:<?php echo $alterego_main_color[3];?>; padding:1px 4px; border-radius: 2px;   -moz-border-radius: 2px;   -webkit-border-radius: 2px; }	






/**************************
	-	BLOCKQUOTE	-
***************************/	
	

		
	blockquote.left,
	quote-left
			{
				margin-top:10px;
				text-align:left; 
				background:url(../images/other/quote_decor_line.png) repeat-y; 
				padding:5px 10px 5px 16px;
				font-size:14px !important;
			}
	
	blockquote.right,
	quote-right
			{
				margin-top:10px;
				float:right;
				text-align:right; 
				background:url(../images/other/quote_decor_line.png) repeat-y right; 
				padding:5px 16px 0px 10px;
				font-size:14px !important;
			}
	
	
	
	
	
/****************************
		-	BLOG CATEGORY	-
*****************************/
		
.blogcategory li				{	border-bottom:1px solid <?php echo $alterego_main_color[2];?>; padding:10px 0px;}
.blogcategory li:first-child	{	border-top:none; padding-top:0px;}
.blogcategory li:last-child		{	border-bottom:none; padding-bottom:0px; margin-bottom:0px;}

.sidebar .blogcategory	a,
.sidebar .blogcategory	a:visited 	{	color:<?php echo $alterego_main_color[3];?>; font-size:12px;}
.sidebar .blogcategory	a:hover		{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}

.footerholder .blogcategory	a,
.footerholder .blogcategory	a:visited 	{	color:<?php echo $alterego_main_color[3];?>; font-size:12px;}
.footerholder .blogcategory	a:hover		{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}
.footerholder .blogcategory li			{	border-bottom:1px solid <?php echo $alterego_main_color[3];?>; padding:10px 0px;}
.footerholder .blogcategory li:first-child	{	border-top:none; padding-top:0px;}


.blog .tags a,
.blog .tags a:visited				{	color:<?php echo $alterego_main_color[3];?>; font-size:12px;}
.blog .tags	a:hover					{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}

.blog .comments a,
.blog .comments a:visited				{	color:<?php echo $alterego_main_color[3];?>; font-size:12px;}
.blog .comments	a:hover			{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}







/*********************************
		-	SIDEBAR TAGS	-
*********************************/

.tagcloud		{	width:100%;}
.tagcloud a,		
.tagcloud a:visited		{	color:<?php echo $alterego_main_color[3];?>;}

.tagcloud a:hover		{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}





/*********************************
	-	POPULAR POSTS	-	
*********************************/

.popularitem					{	height:65px; overflow:visible;margin-top:20px;}
.popularitem .mediaholder		{	float:left; margin-right:10px; margin-top:4px; margin-left:3px; width:65px; height:65px; -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); }	
.popularitem .mediaholder img	{	width:100%}

.popularitem .posttitle			{	color:<?php echo $alterego_main_color[3];?>; font-size:12px; }
.popularitem .posttitle:hover	{ 	color:<?php echo $alterego_main_color[3];?>; }

.popularitem .postdate			{	color:<?php echo $alterego_main_color[3];?>; font-size:10px; }

.popularitem .post_readmore,
.popularitem .post_readmore:visited {	color:<?php echo get_option_tree("alterego_text_color_1");?>; font-size:12px; }
.popularitem .post_readmore:hover	{ 	color:<?php echo $alterego_main_color[3];?>; }




.widgetrotator ul					{	height:175px; width:225px; overflow:hidden;margin-top:-20px; }





/**********************************
	-	WIDGET MEDIAHOLDER	-
***********************************/

.sidebar .fullmediaholder		{width:100%; -webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20); }
.sidebar .fullmediaholder img	{	width:100%; margin-bottom:-5px;}




p.underline	{	text-decoration:underline;}

.sidebar p	{	margin-bottom:0px !important;}





/*********************************
	-	DROPCAP	-
**********************************/
.dropcap:first-letter				{	font-family:'PT Sans Narrow', Arial; float: left; color: #1a2d36;  margin-right:5px; margin-left:3px; margin-top:7px; line-height: 24px; padding:0px 5px !important; font-size:30px;}


.dropcap.circle:first-letter,.dropcap.minirounding:first-letter		{	font-family:'PT Sans Narrow', Arial;  float: left; color: <?php echo $alterego_main_color[5];?>;  margin-right:7px; margin-left:1px; margin-top:5px; line-height:20px; padding:8px 9px!important; font-size:22px; border-radius: 50px; -moz-border-radius: 50px; -webkit-border-radius: 50px;}


.texthighlight						{  border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; padding:2px 2px 2px 2px;}
.texthighlight.fontwhite			{	color:<?php echo $alterego_main_color[5];?> !important;}

.dropcap.minirounding:first-letter				{	border-radius: 2px; -moz-border-radius: 2px; -webkit-border-radius: 2px; }





/********************************
	-	GOOGLEMAP	-
********************************/

#google_map_wrap{
	
	width: 960px;
	height: 320px;
	margin-bottom: 0px;
	
}

#google_map{
	width:960px;
	height: 320px;
}
	
.errormessage, .sendingmessage, .successmessage { float: right !important; font-size: 12px; line-height: 34px; text-decoration: none; display: none;  margin-right: 6px;}
	.errormessage { color: <?php echo $alterego_main_color[1];?>; }
	input[type="text"].formerror, textarea.formerror { border: 1px solid <?php echo $alterego_main_color[1];?> !important; }

	
/************************************
		-	BACK TO TOP	-
*************************************/	
#backtotop					{ width:58px; height:0px;position:fixed; bottom:34px; right:50px; z-index:9999; overflow:hidden;cursor:pointer;
									/* Firefox */
									-moz-transition: all 1s ease;
									/* WebKit */
									-webkit-transition: all 1s ease;
									/* Opera */
									-o-transition: all 1s ease;
									/* Standard */
									transition: all 1s ease;
									-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";	filter: alpha(opacity=0);	-moz-opacity: 0;	-khtml-opacity: 0;	opacity: 0; 
							}
#backtotop.showme			{
								height:58px;							
								-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";	filter: alpha(opacity=100);	-moz-opacity: 1;	-khtml-opacity: 1;	opacity: 1; 
							}
							
#backtotop .bttbg			{ width:58px; height:58px; background:url(../images/other/scroll_to_top.png) no-repeat 0px 0px; }
#backtotop .bttbg:hover		{ background-position: left bottom; }
			
/*Pretty Photo*/
div.pp_default .pp_description{font-family:Arial; font-size:13px;font-weight:500;line-height:14px;margin:10px 50px 5px 0}
div.pp_default .pp_nav .currentTextHolder{font-family:Arial; font-style:italic;color:#999;font-size:11px;left:75px;line-height:25px;position:absolute;top:2px; font-weight:500; margin:0;padding:0 0 0 10px}







/***********************************
	-	ALTEREGO SPECIALS  -
************************************/
.fullwidth_coloredbg,
.highlited_bg			{	margin-left:-30px; margin-right:-30px; width:960px; background-color:<?php echo $alterego_main_color[2];?>;padding:45px 30px 0px;}	


.insidecontainer						{	width:100%;/* background:url(../images/other/shadow_teaser_bottom.png) repeat-x bottom; */padding-bottom:20px;margin-bottom:-20px;}
.tp_teaser .insidecontainer,
.tp_teaser_rotator	.insidecontainer	{	width:225px;}

.footerholder .tp_teaser_rotator .insidecontainer {	width:306px; background:none;}
.footerholder .tp_teaser_rotator > ul > li		{	width:306px;}
.footerholder .one_per_page .tp_teaser_rotator	{	width:310px; padding-top:0px;}
.footerholder .footerdivider_null				{	height:0px;}
.footerholder .widgetrotator ul					{	height:180px; margin-top:-23px;}


.threecolumns .insidecontainer			{	width:100%; /*background:url(../images/other/shadow_team3_bottom.png) repeat-x bottom;*/ padding-bottom:20px;margin-bottom:-20px;}

.insidecontainer_grey					{	background:url(../images/other/shadow_teaser_top.png) repeat-x; background-color:<?php echo $alterego_main_color[3];?>; }


.teaser_title a,
.teaser_title a:visited					{	color:<?php echo get_option_tree("alterego_text_color_1");?>; }

.teaser_title a:hover					{ color:<?php echo $alterego_main_color[1];?> !important;}



.contact_info					{	font-size:11px; line-height:13px;margin-top:10px;}
.footerholder .contact_info		{	font-size:11px; margin-top:20px; line-height:17px;}
.footerholder .video_info		{	font-size:11px; margin-top:10px; line-height:17px;}



.subfooter_container			{ font-size:12px !important; font-family:Arial; color:<?php echo $alterego_main_color[2];?>; }
.subfooter_container a, 
.subfooter_container a:visited	{	color:<?php echo $alterego_main_color[2];?> !important;} 
.subfooter_container a:hover	{	 color:<?php echo get_option_tree("alterego_text_color_1");?> !important;}

.centered						{	margin:auto;}


.portfolio_full_holder h5 a 						{	color:<?php echo get_option_tree("alterego_text_color_1");?>;}
.portfolio_full_holder .insidecontainer_grey		{	padding:15px 20px 15px;}
.portfolio_full_holder .insidecontainer_grey span	{  color:<?php echo $alterego_main_color[2];?>; font-size:12px;}

.padding20container						{	padding:20px;}

.footerholder .mediaholder.scalevid		{-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  }

.sharings_wrap							{	margin-top:5px;}


/*******************************************************
	-	SPECIAL FONTS FOR BUTTONS AND SKILLS	-
********************************************************/
.whitefont,
.whitefont h1,
.whitefont h2,
.whitefont h3,
.whitefont h4,
.whitefont h5		{ color:#fff !important; text-shadow:1px 0px 1px #000 !important;}

.whitefont.button,
.purchase .whitefont		{ text-shadow:none !important;}


.darkfont,
.darkfont h1, 
.darkfont h2, 
.darkfont h3, 
.darkfont h4, 
.darkfont h5 					{ color:#000 !important; text-shadow:1px 0px 1px #fff !important;}


/******************************
	-	RACK CARD	-
*******************************/	

.rack_card				{	background:<?php echo $alterego_main_color[2];?>; position:relative; width:308px;
							-webkit-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        -moz-box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);        box-shadow:  0px 0px 4px 0px rgba(0, 0, 0, 0.20);  
						}
.rack_card .imgholder	{	width:100%; border-bottom:2px solid <?php echo $alterego_main_color[3];?>;}
.rack_card .imgholder img	{	width:100%;margin-bottom:-5px;}
.rack_card .header  	{	background:url(../images/other/shadow_teaser_top.png) repeat-x; background-color:<?php echo $alterego_main_color[3];?>; 
							padding:13px 0px 13px; text-align:center;
						}
.rack_card .header h3,
.rack_card .header h4,
.rack_card .header h5  {	color:<?php echo $alterego_main_color[2];?>; margin-bottom:0px; line-height:0px;margin-top:20px;}
						
.rack_content			{	padding:20px;}
.rack_card_bottomshadow	{	/*background:url(../images/other/shadow_team3_bottom.png) repeat-x bottom;*/ width:305px;/*height:20px;*/}


.mejs-controls .mejs-time-rail .mejs-time-loaded { background: <?php echo $alterego_main_color[1];?> !important;}


#wp-calendar					{	font-size:12px; font-family:"PT Sans Narrow",Arial; color:<?php echo $alterego_main_color[3];?>;}
#wp-calendar caption			{	font-size:16px; color:<?php echo $alterego_main_color[1];?>;}	
#wp-calendar tbody td			{	border:2px solid white;padding:4px 10px;  background:#ebebeb url(../images/other/decor_inside.png) repeat; margin-left:2px;}
#wp-calendar tbody td.pad		{	background:none;border:none;}
#wp-calendar tbody td#today		{	background-color: <?php echo $alterego_main_color[1];?> !important; color:<?php echo $alterego_main_color[5];?>; font-size:14px;}
#wp-calendar tfoot td a,
#wp-calendar tfoot td a:visited	{	font-size:14px;   color:<?php echo $alterego_main_color[3];?> !important;}
#wp-calendar tfoot td a:hover		{	font-size:14px;   color:<?php echo $alterego_main_color[1];?> !important;}
#wp-calendar tfoot td {padding-top:3px;}
#wp-calendar th { color: <?php echo get_option_tree("alterego_text_color_1");?>;}

